"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntitiesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _i18n = require("@kbn/i18n");
var _use_error_toast = require("../../../common/hooks/use_error_toast");
var _manage_query = require("../../../common/components/page/manage_query");
var _common = require("../../../../common/search_strategy/common");
var _use_global_time = require("../../../common/containers/use_global_time");
var _query_toggle = require("../../../common/containers/query_toggle");
var _paginated_table = require("../../../explore/components/paginated_table");
var _severity_filter = require("../severity/severity_filter");
var _entity_source_filter = require("./components/entity_source_filter");
var _use_entities_list_filters = require("./hooks/use_entities_list_filters");
var _asset_criticality_filter = require("../asset_criticality/asset_criticality_filter");
var _use_entities_list_query = require("./hooks/use_entities_list_query");
var _constants = require("./constants");
var _use_entities_list_columns = require("./hooks/use_entities_list_columns");
var _use_enabled_entity_types = require("../../hooks/use_enabled_entity_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_store/entities_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EntitiesList = () => {
  var _data$inspect, _data$total, _data$records, _data$total2;
  const {
    deleteQuery,
    setQuery,
    isInitializing,
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const [limit, setLimit] = (0, _react.useState)(10);
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(_constants.ENTITIES_LIST_TABLE_ID);
  const [sorting, setSorting] = (0, _react.useState)({
    field: '@timestamp',
    direction: _common.Direction.desc
  });
  const entityTypes = (0, _use_enabled_entity_types.useEntityStoreTypes)();
  const [selectedSeverities, setSelectedSeverities] = (0, _react.useState)([]);
  const [selectedCriticalities, setSelectedCriticalities] = (0, _react.useState)([]);
  const [selectedSources, setSelectedSources] = (0, _react.useState)([]);
  const filter = (0, _use_entities_list_filters.useEntitiesListFilters)({
    selectedSeverities,
    selectedCriticalities,
    selectedSources
  });
  const [querySkip, setQuerySkip] = (0, _react.useState)(isInitializing || !toggleStatus);
  (0, _react.useEffect)(() => {
    if (!isInitializing) {
      setQuerySkip(isInitializing || !toggleStatus);
    }
  }, [isInitializing, toggleStatus]);
  const onSort = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const newSort = criteria.sort;
      if (newSort.direction !== sorting.direction || newSort.field !== sorting.field) {
        setSorting(newSort);
      }
    }
  }, [setSorting, sorting]);
  const searchParams = (0, _react.useMemo)(() => ({
    entityTypes,
    page: activePage + 1,
    perPage: limit,
    sortField: sorting.field,
    sortOrder: sorting.direction,
    skip: querySkip,
    filterQuery: JSON.stringify({
      bool: {
        filter
      }
    })
  }), [entityTypes, activePage, limit, sorting.field, sorting.direction, querySkip, filter]);
  const {
    data,
    isLoading,
    isRefetching,
    refetch,
    error
  } = (0, _use_entities_list_query.useEntitiesListQuery)(searchParams);
  (0, _manage_query.useQueryInspector)({
    queryId: _constants.ENTITIES_LIST_TABLE_ID,
    loading: isLoading || isRefetching,
    refetch,
    setQuery,
    deleteQuery,
    inspect: (_data$inspect = data === null || data === void 0 ? void 0 : data.inspect) !== null && _data$inspect !== void 0 ? _data$inspect : null
  });

  // Reset the active page when the search criteria changes
  (0, _react.useEffect)(() => {
    setActivePage(0);
  }, [sorting, limit, filter]);
  const columns = (0, _use_entities_list_columns.useEntitiesListColumns)();

  // Force a refetch when "refresh" button is clicked.
  // If we implement the timerange filter we can get rid of this code
  (0, _react.useEffect)(() => {
    refetch();
  }, [from, to, refetch]);
  (0, _use_error_toast.useErrorToast)(_i18n.i18n.translate('xpack.securitySolution.entityAnalytics.entityStore.entitiesList.queryError', {
    defaultMessage: 'There was an error loading the entities list'
  }), error);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    id: _constants.ENTITIES_LIST_TABLE_ID,
    activePage: activePage,
    columns: columns,
    headerCount: (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0,
    titleSize: "s",
    headerTitle: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.entityStore.entitiesList.tableTitle', {
      defaultMessage: 'Entities'
    }),
    headerTooltip: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.entityStore.entitiesList.tableTooltip', {
      defaultMessage: 'Entity data can take a couple of minutes to appear'
    }),
    limit: limit,
    loading: isLoading || isRefetching,
    isInspect: false,
    updateActivePage: setActivePage,
    loadPage: _fp.noop // It isn't necessary because the page loads when activePage changes
    ,
    pageOfItems: (_data$records = data === null || data === void 0 ? void 0 : data.records) !== null && _data$records !== void 0 ? _data$records : [],
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: false,
    updateLimitPagination: setLimit,
    totalCount: (_data$total2 = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total2 !== void 0 ? _data$total2 : 0,
    itemsPerRow: _constants.rowItems,
    sorting: sorting,
    onChange: onSort,
    headerFilters: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_severity_filter.SeverityFilter, {
      selectedItems: selectedSeverities,
      onSelect: setSelectedSeverities,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_asset_criticality_filter.AssetCriticalityFilter, {
      selectedItems: selectedCriticalities,
      onChange: setSelectedCriticalities,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_entity_source_filter.EntitySourceFilter, {
      selectedItems: selectedSources,
      onChange: setSelectedSources,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  });
};
exports.EntitiesList = EntitiesList;