"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnablementPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _use_init_risk_engine_mutation = require("../../../api/hooks/use_init_risk_engine_mutation");
var _use_entity_store = require("../hooks/use_entity_store");
var _translations = require("../translations");
var _enablement_modal = require("./enablement_modal");
var _entity_store_dashboard = _interopRequireDefault(require("../../../images/entity_store_dashboard.png"));
var _use_enabled_entity_types = require("../../../hooks/use_enabled_entity_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_store/components/dashboard_enablement_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EnablementPanel = ({
  state
}) => {
  var _state$riskEngine$dat, _state$entityStore$da, _state$entityStore$da2;
  const riskEngineStatus = (_state$riskEngine$dat = state.riskEngine.data) === null || _state$riskEngine$dat === void 0 ? void 0 : _state$riskEngine$dat.risk_engine_status;
  const entityStoreStatus = (_state$entityStore$da = state.entityStore.data) === null || _state$entityStore$da === void 0 ? void 0 : _state$entityStore$da.status;
  const engines = (_state$entityStore$da2 = state.entityStore.data) === null || _state$entityStore$da2 === void 0 ? void 0 : _state$entityStore$da2.engines;
  const enabledEntityTypes = (0, _use_enabled_entity_types.useEntityStoreTypes)();
  const [modal, setModalState] = (0, _react.useState)({
    visible: false
  });
  const [riskEngineInitializing, setRiskEngineInitializing] = (0, _react.useState)(false);
  const initRiskEngine = (0, _use_init_risk_engine_mutation.useInitRiskEngineMutation)();
  const storeEnablement = (0, _use_entity_store.useEnableEntityStoreMutation)();
  const enableEntityStore = (0, _react.useCallback)(enable => () => {
    if (enable.riskScore) {
      const options = {
        onSuccess: () => {
          setRiskEngineInitializing(false);
          if (enable.entityStore) {
            storeEnablement.mutate({});
          }
        }
      };
      setRiskEngineInitializing(true);
      initRiskEngine.mutate(undefined, options);
      setModalState({
        visible: false
      });
      return;
    }
    if (enable.entityStore) {
      storeEnablement.mutate({});
      setModalState({
        visible: false
      });
    }
  }, [storeEnablement, initRiskEngine]);
  const installedTypes = engines === null || engines === void 0 ? void 0 : engines.map(engine => engine.type);
  const uninstalledTypes = enabledEntityTypes.filter(type => !(installedTypes || []).includes(type));
  const enableUninstalledEntityStore = () => {
    storeEnablement.mutate({
      entityTypes: uninstalledTypes
    });
  };
  if (storeEnablement.error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.entityStore.enablement.mutation.errorTitle",
        defaultMessage: 'There was a problem initializing the entity store',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 11
        }
      }),
      color: "danger",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 9
      }
    }, storeEnablement.error.body.message));
  }
  if (riskEngineInitializing) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      "data-test-subj": "riskEngineInitializingPanel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoElastic",
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 17
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 18
        }
      }, _translations.ENABLEMENT_INITIALIZING_RISK_ENGINE),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 9
      }
    }));
  }
  if (entityStoreStatus === 'installing' || storeEnablement.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      "data-test-subj": "entityStoreInitializingPanel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoElastic",
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 17
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 18
        }
      }, _translations.ENABLEMENT_INITIALIZING_ENTITY_STORE),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.entityStore.enablement.initializing.description",
        defaultMessage: "This can take up to 5 minutes.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 15
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }));
  }
  if (entityStoreStatus === 'running' && uninstalledTypes.length > 0) {
    const title = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.entityStore.enablement.moreEntityTypesTitle', {
      defaultMessage: 'More entity types available'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      css: {
        minWidth: '100%'
      },
      hasBorder: true,
      layout: "horizontal",
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: title,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        fill: true,
        onClick: enableUninstalledEntityStore,
        "data-test-subj": `entityStoreEnablementButton`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.entityStore.enablement.enableButton",
        defaultMessage: "Enable",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 15
        }
      }))),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
        size: "l",
        hasShadow: true,
        src: _entity_store_dashboard.default,
        alt: title,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 15
        }
      }),
      "data-test-subj": "entityStoreEnablementPanel",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 16
        }
      }, title),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.entityStore.enablement.moreEntityTypes",
        defaultMessage: 'Enable missing types in the entity store to capture even more entities observed in events',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 7
      }
    });
  }
  if (riskEngineStatus !== _entity_analytics.RiskEngineStatusEnum.NOT_INSTALLED && entityStoreStatus !== 'not_installed') {
    return null;
  }
  const [title, body] = getEnablementTexts(entityStoreStatus, riskEngineStatus);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: {
      minWidth: '100%'
    },
    hasBorder: true,
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 16
      }
    }, title),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 15
      }
    }, body),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: () => setModalState({
        visible: true
      }),
      "data-test-subj": `entityStoreEnablementButton`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enablement.enableButton",
      defaultMessage: "Enable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 15
      }
    }))),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "l",
      hasShadow: true,
      src: _entity_store_dashboard.default,
      alt: title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    }),
    "data-test-subj": "entityStoreEnablementPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_enablement_modal.EntityStoreEnablementModal, {
    visible: modal.visible,
    toggle: visible => setModalState({
      visible
    }),
    enableStore: enableEntityStore,
    riskEngineStatus: riskEngineStatus,
    entityStoreStatus: entityStoreStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }));
};
exports.EnablementPanel = EnablementPanel;
const getEnablementTexts = (entityStoreStatus, riskEngineStatus) => {
  if ((entityStoreStatus === 'not_installed' || entityStoreStatus === 'stopped') && riskEngineStatus === _entity_analytics.RiskEngineStatusEnum.NOT_INSTALLED) {
    return [_translations.ENABLE_ALL_TITLE, _translations.ENABLEMENT_DESCRIPTION_BOTH];
  }
  if (riskEngineStatus === _entity_analytics.RiskEngineStatusEnum.NOT_INSTALLED) {
    return [_translations.ENABLE_RISK_SCORE_TITLE, _translations.ENABLEMENT_DESCRIPTION_RISK_ENGINE_ONLY];
  }
  return [_translations.ENABLE_ENTITY_STORE_TITLE, _translations.ENABLEMENT_DESCRIPTION_ENTITY_STORE_ONLY];
};