"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableJob = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _links = require("../../../../common/components/links");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_enable_data_feed = require("../../../../common/components/ml_popover/hooks/use_enable_data_feed");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_analytics_anomalies/components/enable_job.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EnableJob = ({
  job,
  isLoading,
  onJobEnabled
}) => {
  const {
    enableDatafeed,
    isLoading: isEnabling
  } = (0, _use_enable_data_feed.useEnableDataFeed)();
  const handleChange = (0, _react.useCallback)(async () => {
    const result = await enableDatafeed(job, job.latestTimestampMs || 0);
    if (result.enabled) {
      onJobEnabled(job);
    }
  }, [enableDatafeed, job, onJobEnabled]);
  return isLoading || isEnabling ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "job-switch-loader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: handleChange,
    "data-test-subj": "enable-job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, i18n.RUN_JOB);
};
exports.EnableJob = EnableJob;