"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrations = exports.INTEGRATION_OPTION_TEST_ID = void 0;
var _react = require("react");
var _constants = require("../../constants");
var _filter = require("../../utils/filter");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_OPTION_TEST_ID = exports.INTEGRATION_OPTION_TEST_ID = 'alert-summary-integration-option-';
/**
 * Creates an interface that the IntegrationFilterButton can take as input (as EuiSelectableOption).
 * If a filter exists (we assume that this filter is negated) we do not mark the integration as checked for the EuiFilterButton.
 */
const useIntegrations = ({
  packages
}) => {
  const {
    data: {
      query: {
        filterManager
      }
    }
  } = (0, _kibana.useKibana)().services;

  // There can be existing rules filtered out, coming when parsing the url
  const currentFilters = filterManager.getFilters();
  const integrations = (0, _react.useMemo)(() => {
    const result = [];
    packages.forEach(p => {
      // Retrieves the filter from the key/value pair
      const currentFilter = (0, _filter.filterExistsInFiltersArray)(currentFilters, _constants.RELATED_INTEGRATION, p.name);

      // A EuiSelectableOption is checked only if there is no matching filter for that rule
      const integration = {
        'data-test-subj': `${INTEGRATION_OPTION_TEST_ID}${p.title}`,
        ...(!currentFilter && {
          checked: 'on'
        }),
        key: p.name,
        label: p.title
      };
      result.push(integration);
    });
    return result;
  }, [currentFilters, packages]);
  return (0, _react.useMemo)(() => ({
    integrations
  }), [integrations]);
};
exports.useIntegrations = useIntegrations;