"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wrapper = exports.SKELETON_TEST_ID = exports.DATA_VIEW_LOADING_PROMPT_TEST_ID = exports.DATA_VIEW_ERROR_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _header_page = require("../../../common/components/header_page");
var _containers = require("../../../sourcerer/containers");
var _model = require("../../../sourcerer/store/model");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _content = require("./content");
var _translations = require("../../pages/alerts/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts/wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DATA_VIEW_LOADING_PROMPT_TEST_ID = exports.DATA_VIEW_LOADING_PROMPT_TEST_ID = 'alerts-page-data-view-loading-prompt';
const DATA_VIEW_ERROR_TEST_ID = exports.DATA_VIEW_ERROR_TEST_ID = 'alerts-page-data-view-error';
const SKELETON_TEST_ID = exports.SKELETON_TEST_ID = 'alerts-page-skeleton';
const DATAVIEW_ERROR = _i18n.i18n.translate('xpack.securitySolution.alertsPage.dataViewError', {
  defaultMessage: 'Unable to retrieve the data view'
});

/**
 * Retrieves the dataView for the alerts page then renders the alerts page when the dataView is valid.
 * Shows a loading skeleton while retrieving.
 * Shows an error message if the dataView is invalid.
 */
const Wrapper = exports.Wrapper = /*#__PURE__*/(0, _react.memo)(() => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    sourcererDataView: oldSourcererDataViewSpec,
    loading: oldSourcererDataViewIsLoading
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);
  // TODO rename to just dataView and status once we remove the newDataViewPickerEnabled feature flag
  const {
    dataView: experimentalDataView,
    status: experimentalDataViewStatus
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);
  const isLoading = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalDataViewStatus === 'loading' || experimentalDataViewStatus === 'pristine' : oldSourcererDataViewIsLoading, [experimentalDataViewStatus, newDataViewPickerEnabled, oldSourcererDataViewIsLoading]);

  // TODO this will not be needed anymore once we remove the newDataViewPickerEnabled feature flag.
  //  We currently only need the runtimeMappings in the KPIsSection, so we can just pass down the dataView
  //  and extract the runtimeMappings from it there using experimentalDataView.getRuntimeMappings()
  const runtimeMappings = (0, _react.useMemo)(() => {
    var _ref, _ref2;
    return newDataViewPickerEnabled ? (_ref = experimentalDataView === null || experimentalDataView === void 0 ? void 0 : experimentalDataView.getRuntimeMappings()) !== null && _ref !== void 0 ? _ref : {} // TODO remove the ? as the dataView should never be undefined
    : (_ref2 = oldSourcererDataViewSpec === null || oldSourcererDataViewSpec === void 0 ? void 0 : oldSourcererDataViewSpec.runtimeFieldMap) !== null && _ref2 !== void 0 ? _ref2 : {};
  }, [newDataViewPickerEnabled, experimentalDataView, oldSourcererDataViewSpec === null || oldSourcererDataViewSpec === void 0 ? void 0 : oldSourcererDataViewSpec.runtimeFieldMap]);
  const isDataViewInvalid = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalDataViewStatus === 'error' || experimentalDataViewStatus === 'ready' && !experimentalDataView.hasMatchedIndices() : !oldSourcererDataViewSpec || !oldSourcererDataViewSpec.id || !oldSourcererDataViewSpec.title, [experimentalDataView, experimentalDataViewStatus, newDataViewPickerEnabled, oldSourcererDataViewSpec]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    "data-test-subj": DATA_VIEW_LOADING_PROMPT_TEST_ID,
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": SKELETON_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 40,
      width: "100%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
      title: _translations.PAGE_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 40,
      width: 110,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 40,
      width: 110,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 32,
      width: "100%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 375,
      width: "100%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 600,
      width: "100%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    })),
    loadedContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDataViewInvalid ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      "data-test-subj": DATA_VIEW_ERROR_TEST_ID,
      iconType: "error",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 22
        }
      }, DATAVIEW_ERROR),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_content.AlertsPageContent, {
      dataView: experimentalDataView,
      oldSourcererDataViewSpec: oldSourcererDataViewSpec,
      runtimeMappings: runtimeMappings,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  });
});
Wrapper.displayName = 'Wrapper';