"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _formatted_date = require("../../../../common/components/formatted_date");
var _event_type_indicator = require("../basic/indicators/event_type_indicator");
var _log_level_indicator = require("../basic/indicators/log_level_indicator");
var _truncated_text = require("../basic/text/truncated_text");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_monitoring/components/execution_events_table/use_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useColumns = args => {
  const {
    toggleRowExpanded,
    isRowExpanded
  } = args;
  return (0, _react.useMemo)(() => {
    return [timestampColumn, logLevelColumn, eventTypeColumn, messageColumn, expanderColumn({
      toggleRowExpanded,
      isRowExpanded
    })];
  }, [toggleRowExpanded, isRowExpanded]);
};
exports.useColumns = useColumns;
const timestampColumn = {
  field: 'timestamp',
  name: i18n.COLUMN_TIMESTAMP,
  render: value => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
    value: value,
    fieldName: "timestamp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 30
    }
  }),
  sortable: true,
  truncateText: false,
  width: '20%'
};
const logLevelColumn = {
  field: 'level',
  name: i18n.COLUMN_LOG_LEVEL,
  render: value => /*#__PURE__*/_react.default.createElement(_log_level_indicator.LogLevelIndicator, {
    logLevel: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 32
    }
  }),
  sortable: false,
  truncateText: false,
  width: '8%'
};
const eventTypeColumn = {
  field: 'type',
  name: i18n.COLUMN_EVENT_TYPE,
  render: value => /*#__PURE__*/_react.default.createElement(_event_type_indicator.EventTypeIndicator, {
    type: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 46
    }
  }),
  sortable: false,
  truncateText: false,
  width: '8%'
};
const messageColumn = {
  field: 'message',
  name: i18n.COLUMN_MESSAGE,
  render: value => /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
    text: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 30
    }
  }),
  sortable: false,
  truncateText: true,
  width: '64%'
};
const expanderColumn = ({
  toggleRowExpanded,
  isRowExpanded
}) => {
  return {
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, 'Expand rows')),
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleRowExpanded(item),
      "aria-label": isRowExpanded(item) ? 'Collapse' : 'Expand',
      iconType: isRowExpanded(item) ? 'arrowUp' : 'arrowDown',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    })
  };
};