"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradePrebuiltRulesTableFilters = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_prebuilt_rules_customization_status = require("../../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_customization_status");
var _rule_search_field = require("../rules_table_filters/rule_search_field");
var _tags_filter_popover = require("../rules_table_filters/tags_filter_popover");
var i18n = _interopRequireWildcard(require("./translations"));
var _upgrade_prebuilt_rules_table_context = require("./upgrade_prebuilt_rules_table_context");
var _upgrade_rule_customization_filter_popover = require("./upgrade_rule_customization_filter_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/upgrade_prebuilt_rules_table_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FilterWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeM};
`;

/**
 * Collection of filters for filtering data within the Upgrade Prebuilt Rules table.
 * Contains search bar and tag selection
 */
const UpgradePrebuiltRulesTableFiltersComponent = () => {
  var _filterOptions$name;
  const {
    state: {
      filterOptions,
      tags
    },
    actions: {
      setFilterOptions
    }
  } = (0, _upgrade_prebuilt_rules_table_context.useUpgradePrebuiltRulesTableContext)();
  const {
    isRulesCustomizationEnabled
  } = (0, _use_prebuilt_rules_customization_status.usePrebuiltRulesCustomizationStatus)();
  const {
    tags: selectedTags,
    customization_status: customizationStatus
  } = filterOptions;
  const handleOnSearch = (0, _react.useCallback)(nameString => {
    setFilterOptions(filters => ({
      ...filters,
      name: nameString.trim()
    }));
  }, [setFilterOptions]);
  const handleSelectedTags = (0, _react.useCallback)(newTags => {
    if (!(0, _fp.isEqual)(newTags, selectedTags)) {
      setFilterOptions(filters => ({
        ...filters,
        tags: newTags
      }));
    }
  }, [selectedTags, setFilterOptions]);
  const handleCustomizationStatusChange = (0, _react.useCallback)(newCustomizationStatus => {
    setFilterOptions(filters => ({
      ...filters,
      customization_status: newCustomizationStatus
    }));
  }, [setFilterOptions]);
  return /*#__PURE__*/_react.default.createElement(FilterWrapper, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_search_field.RuleSearchField, {
    initialValue: (_filterOptions$name = filterOptions.name) !== null && _filterOptions$name !== void 0 ? _filterOptions$name : '',
    onSearch: handleOnSearch,
    placeholder: i18n.SEARCH_PLACEHOLDER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, isRulesCustomizationEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_upgrade_rule_customization_filter_popover.RuleCustomizationFilterPopover, {
    onCustomizationStatusChanged: handleCustomizationStatusChange,
    customizationStatus: customizationStatus,
    "data-test-subj": "upgradeRulesRuleCustomizationPopover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_tags_filter_popover.TagsFilterPopover, {
    onSelectedTagsChanged: handleSelectedTags,
    selectedTags: selectedTags !== null && selectedTags !== void 0 ? selectedTags : [],
    tags: tags,
    "data-test-subj": "upgradeRulesTagPopover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  })))));
};
UpgradePrebuiltRulesTableFiltersComponent.displayName = 'UpgradePrebuiltRulesTableFiltersComponent';
const UpgradePrebuiltRulesTableFilters = exports.UpgradePrebuiltRulesTableFilters = /*#__PURE__*/_react.default.memo(UpgradePrebuiltRulesTableFiltersComponent);
UpgradePrebuiltRulesTableFilters.displayName = 'UpgradePrebuiltRulesTableFilters';