"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPrebuiltRulesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../constants");
var _add_prebuilt_rules_no_items_message = require("./add_prebuilt_rules_no_items_message");
var _add_prebuilt_rules_table_context = require("./add_prebuilt_rules_table_context");
var _add_prebuilt_rules_table_filters = require("./add_prebuilt_rules_table_filters");
var _use_add_prebuilt_rules_table_columns = require("./use_add_prebuilt_rules_table_columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/add_prebuilt_rules_table/add_prebuilt_rules_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Table Component for displaying new rules that are available to be installed
 */
const AddPrebuiltRulesTable = exports.AddPrebuiltRulesTable = /*#__PURE__*/_react.default.memo(() => {
  const addRulesTableContext = (0, _add_prebuilt_rules_table_context.useAddPrebuiltRulesTableContext)();
  const {
    state: {
      rules,
      hasRulesToInstall,
      isLoading,
      isRefetching,
      selectedRules,
      isUpgradingSecurityPackages
    },
    actions: {
      selectRules
    }
  } = addRulesTableContext;
  const rulesColumns = (0, _use_add_prebuilt_rules_table_columns.useAddPrebuiltRulesTableColumns)();
  const shouldShowProgress = isUpgradingSecurityPackages || isRefetching;
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const handleTableChange = (0, _react.useCallback)(({
    page: {
      index
    }
  }) => {
    setPageIndex(index);
  }, [setPageIndex]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "loadingRulesInfoProgress",
    size: "xs",
    position: "absolute",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 13
      }
    })),
    loadedContent: !hasRulesToInstall ? /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_no_items_message.AddPrebuiltRulesTableNoItemsMessage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_table_filters.AddPrebuiltRulesTableFilters, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: rules,
      sorting: true,
      pagination: {
        initialPageSize: _constants.RULES_TABLE_INITIAL_PAGE_SIZE,
        pageSizeOptions: _constants.RULES_TABLE_PAGE_SIZE_OPTIONS,
        pageIndex
      },
      selection: {
        selectable: () => true,
        onSelectionChange: selectRules,
        initialSelected: selectedRules
      },
      itemId: "rule_id",
      "data-test-subj": "add-prebuilt-rules-table",
      columns: rulesColumns,
      onTableChange: handleTableChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
});
AddPrebuiltRulesTable.displayName = 'AddPrebuiltRulesTable';