"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MachineLearningRuleFieldEdit = MachineLearningRuleFieldEdit;
var _react = _interopRequireDefault(require("react"));
var _anomaly_threshold_form = require("./fields/anomaly_threshold/anomaly_threshold_form");
var _alert_suppression = require("./fields/alert_suppression");
var _machine_learning_job_id_form = require("./fields/machine_learning_job_id/machine_learning_job_id_form");
var _utility_types = require("../../../../../../../common/utility_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/machine_learning_rule_field_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MachineLearningRuleFieldEdit({
  fieldName
}) {
  switch (fieldName) {
    case 'alert_suppression':
      return /*#__PURE__*/_react.default.createElement(_alert_suppression.AlertSuppressionEditForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 22,
          columnNumber: 14
        }
      });
    case 'anomaly_threshold':
      return /*#__PURE__*/_react.default.createElement(_anomaly_threshold_form.AnomalyThresholdForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 24,
          columnNumber: 14
        }
      });
    case 'machine_learning_job_id':
      return /*#__PURE__*/_react.default.createElement(_machine_learning_job_id_form.MachineLearningJobIdForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 26,
          columnNumber: 14
        }
      });
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}