"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampOverrideEdit = TimestampOverrideEdit;
exports.timestampOverrideDeserializer = timestampOverrideDeserializer;
exports.timestampOverrideSchema = void 0;
exports.timestampOverrideSerializer = timestampOverrideSerializer;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../../../../shared_imports");
var _schema = require("../../../../../../rule_creation_ui/components/step_about_rule/schema");
var _es_field_selector_field = require("../../../../../../rule_creation_ui/components/es_field_selector_field");
var _use_default_index_pattern = require("../../../../../hooks/use_default_index_pattern");
var _utils = require("../utils");
var _form = require("../../../../../../rule_creation_ui/pages/form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/timestamp_override.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const timestampOverrideSchema = exports.timestampOverrideSchema = {
  timestampOverride: _schema.schema.timestampOverride,
  timestampOverrideFallbackDisabled: _schema.schema.timestampOverrideFallbackDisabled
};
function TimestampOverrideEdit({
  finalDiffableRule
}) {
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const indexPatternParameters = (0, _utils.getUseRuleIndexPatternParameters)(finalDiffableRule, defaultIndexPattern);
  const {
    indexPattern,
    isIndexPatternLoading
  } = (0, _form.useRuleIndexPattern)(indexPatternParameters);
  const componentProps = (0, _react.useMemo)(() => ({
    fieldType: 'date',
    indices: indexPattern,
    isDisabled: isIndexPatternLoading
  }), [indexPattern, isIndexPatternLoading]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "timestampOverride",
    component: _es_field_selector_field.EsFieldSelectorField,
    componentProps: componentProps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(TimestampFallbackDisabled, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
}
function TimestampFallbackDisabled() {
  const [formData] = (0, _shared_imports.useFormData)();
  const {
    timestampOverride
  } = formData;
  if (timestampOverride && timestampOverride !== '@timestamp') {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "timestampOverrideFallbackDisabled",
      component: _shared_imports.Field,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 12
      }
    });
  }
  return null;
}
function timestampOverrideDeserializer(_, finalDiffableRule) {
  var _finalDiffableRule$ti, _finalDiffableRule$ti2, _finalDiffableRule$ti3;
  return {
    timestampOverride: (_finalDiffableRule$ti = finalDiffableRule.timestamp_override) === null || _finalDiffableRule$ti === void 0 ? void 0 : _finalDiffableRule$ti.field_name,
    timestampOverrideFallbackDisabled: (_finalDiffableRule$ti2 = (_finalDiffableRule$ti3 = finalDiffableRule.timestamp_override) === null || _finalDiffableRule$ti3 === void 0 ? void 0 : _finalDiffableRule$ti3.fallback_disabled) !== null && _finalDiffableRule$ti2 !== void 0 ? _finalDiffableRule$ti2 : false
  };
}
function timestampOverrideSerializer(formData) {
  if (formData.timestampOverride === '') {
    return {
      timestamp_override: undefined
    };
  }
  return {
    timestamp_override: {
      field_name: formData.timestampOverride,
      fallback_disabled: formData.timestampOverrideFallbackDisabled
    }
  };
}