"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiffableRuleDataView = useDiffableRuleDataView;
var _detection_engine = require("../../../../../../../../../common/api/detection_engine");
var _use_default_index_pattern = require("../../../../../../hooks/use_default_index_pattern");
var _use_data_view = require("./use_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDiffableRuleDataView(diffableRule) {
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const defaultDataSource = {
    type: _detection_engine.DataSourceType.index_patterns,
    index_patterns: defaultIndexPattern
  };
  const dataSource = 'data_source' in diffableRule && diffableRule.data_source || defaultDataSource;
  return (0, _use_data_view.useDataView)(dataSource.type === _detection_engine.DataSourceType.index_patterns ? {
    indexPatterns: dataSource.index_patterns
  } : {
    dataViewId: dataSource.data_view_id
  });
}