"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Hunks = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDiffView = require("react-diff-view");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/json_diff/hunks.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UnfoldButton = ({
  start,
  end,
  onExpand,
  ...props
}) => {
  const expand = (0, _react.useCallback)(() => onExpand(start, end), [onExpand, start, end]);
  const linesCount = end - start;
  return /*#__PURE__*/_react.default.createElement(_reactDiffView.Decoration, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, start > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: expand,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 15
    }
  }, i18n.EXPAND_UNCHANGED_LINES(linesCount))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  })));
};
const UnfoldCollapsed = ({
  previousHunk,
  currentHunk,
  linesCount,
  onExpand
}) => {
  if (!currentHunk) {
    const nextStart = previousHunk.oldStart + previousHunk.oldLines;
    const collapsedLines = linesCount - nextStart + 1;
    if (collapsedLines <= 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(UnfoldButton, {
      start: nextStart,
      end: linesCount + 1,
      onExpand: onExpand,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 12
      }
    });
  }
  const collapsedLines = (0, _reactDiffView.getCollapsedLinesCountBetween)(previousHunk, currentHunk);
  if (!previousHunk) {
    if (!collapsedLines) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(UnfoldButton, {
      start: 1,
      end: currentHunk.oldStart,
      onExpand: onExpand,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 12
      }
    });
  }
  const collapsedStart = previousHunk.oldStart + previousHunk.oldLines;
  const collapsedEnd = currentHunk.oldStart;
  return /*#__PURE__*/_react.default.createElement(UnfoldButton, {
    start: collapsedStart,
    end: collapsedEnd,
    onExpand: onExpand,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 10
    }
  });
};
const Hunks = ({
  hunks,
  oldSource,
  expandRange
}) => {
  const linesCount = oldSource.split('\n').length;
  const hunkElements = hunks.reduce((children, hunk, index) => {
    const previousElement = children[children.length - 1];

    // If old source doesn't exist, we don't render expandable sections
    if (!oldSource) {
      children.push(/*#__PURE__*/_react.default.createElement(_reactDiffView.Hunk, {
        key: `hunk-${hunk.content}`,
        hunk: hunk,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 21
        }
      }));
      return children;
    }
    children.push(/*#__PURE__*/_react.default.createElement(UnfoldCollapsed, {
      key: `decoration-${hunk.content}`,
      previousHunk: previousElement && previousElement.props.hunk,
      currentHunk: hunk,
      linesCount: linesCount,
      onExpand: expandRange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    }));
    children.push(/*#__PURE__*/_react.default.createElement(_reactDiffView.Hunk, {
      key: `hunk-${hunk.content}`,
      hunk: hunk,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 19
      }
    }));
    const isLastHunk = index === hunks.length - 1;
    if (isLastHunk && oldSource) {
      children.push(/*#__PURE__*/_react.default.createElement(UnfoldCollapsed, {
        key: "decoration-tail",
        previousHunk: hunk,
        linesCount: linesCount,
        onExpand: expandRange,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 9
        }
      }));
    }
    return children;
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hunkElements);
};
exports.Hunks = Hunks;