"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateGetRuleIdsWithGapsQuery = exports.useGetRuleIdsWithGaps = void 0;
var _react = require("react");
var _reactQuery = require("@kbn/react-query");
var _api = require("../api");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GET_RULE_IDS_WITH_GAPS = ['GET_RULE_IDS_WITH_GAPS'];
const useInvalidateGetRuleIdsWithGapsQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries([GET_RULE_IDS_WITH_GAPS], {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateGetRuleIdsWithGapsQuery = useInvalidateGetRuleIdsWithGapsQuery;
const useGetRuleIdsWithGaps = ({
  gapRange,
  statuses,
  hasUnfilledIntervals,
  hasInProgressIntervals,
  hasFilledIntervals
}, options) => {
  return (0, _reactQuery.useQuery)([GET_RULE_IDS_WITH_GAPS, gapRange, ...statuses, hasUnfilledIntervals, hasInProgressIntervals, hasFilledIntervals], async ({
    signal
  }) => {
    const {
      start,
      end
    } = (0, _utils.getGapRange)(gapRange);
    const response = await (0, _api.getRuleIdsWithGaps)({
      signal,
      start,
      end,
      statuses,
      hasUnfilledIntervals,
      hasInProgressIntervals,
      hasFilledIntervals
    });
    return response;
  }, {
    retry: 0,
    keepPreviousData: true,
    ...options
  });
};
exports.useGetRuleIdsWithGaps = useGetRuleIdsWithGaps;