"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsConditions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/lists-plugin/public");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _utils = require("../../../../../../common/detection_engine/utils");
var _kibana = require("../../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var sharedI18n = _interopRequireWildcard(require("../../../utils/translations"));
var _show_value_list_modal = require("../../../../../value_list/components/show_value_list_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/item_conditions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OS_OPTIONS = [{
  label: sharedI18n.OPERATING_SYSTEM_WINDOWS,
  value: ['windows']
}, {
  label: sharedI18n.OPERATING_SYSTEM_MAC,
  value: ['macos']
}, {
  label: sharedI18n.OPERATING_SYSTEM_LINUX,
  value: ['linux']
}, {
  label: sharedI18n.OPERATING_SYSTEM_WINDOWS_AND_MAC,
  value: ['windows', 'macos']
}];
const SectionHeader = (0, _styledComponents.default)(_eui.EuiTitle)`
  ${() => (0, _styledComponents.css)`
    font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  `}
`;
const ExceptionsConditionsComponent = ({
  exceptionItemName,
  allowLargeValueLists,
  exceptionListItems,
  indexPatterns,
  rules,
  exceptionListType,
  showOsTypeOptions,
  selectedOs,
  isEdit,
  onOsChange,
  onExceptionItemAdd,
  onSetErrorExists,
  getExtendedFields
}) => {
  const {
    http,
    unifiedSearch
  } = (0, _kibana.useKibana)().services;
  const isEndpointException = (0, _react.useMemo)(() => exceptionListType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT, [exceptionListType]);
  const includesRuleWithEQLSequenceStatement = (0, _react.useMemo)(() => {
    return rules != null && rules.some(rule => rule.type === 'eql' && (0, _utils.hasEqlSequenceQuery)(rule.query));
  }, [rules]);

  // If editing an item (can only edit a single item at a time), get it's
  // list_id. Otherwise, if it is an item for an endpoint list, the list_id is
  // hard coded. For all others, we'll fill in the appropriate list_id when
  // enriching items before creating when we know if they'll be added to the rule_default
  // list or a shared list.
  const listIdToUse = (0, _react.useMemo)(() => {
    if (isEndpointException) {
      return 'endpoint_list';
    }
    const defaultValue = isEndpointException ? _securitysolutionListConstants.ENDPOINT_LIST_ID : undefined;
    return isEdit ? exceptionListItems[0].list_id : defaultValue;
  }, [isEndpointException, isEdit, exceptionListItems]);

  // If editing an item (can only edit a single item at a time), get it's
  // namespace_type. Otherwise, if it is an item for an endpoint list, the namespace_type is
  // 'agnostic'. For all others, we'll fill in the appropriate list_id when
  // enriching items before creating when we know if they'll be added to the rule_default
  // list or a shared list.
  const listNamespaceType = (0, _react.useMemo)(() => {
    const defaultValue = isEndpointException ? 'agnostic' : undefined;
    return isEdit ? exceptionListItems[0].namespace_type : defaultValue;
  }, [exceptionListItems, isEdit, isEndpointException]);
  const handleBuilderOnChange = (0, _react.useCallback)(({
    exceptionItems,
    errorExists
  }) => {
    onExceptionItemAdd(exceptionItems);
    onSetErrorExists(errorExists);
  }, [onSetErrorExists, onExceptionItemAdd]);
  const handleOSSelectionChange = (0, _react.useCallback)(selectedOptions => {
    const os = selectedOptions[0].value;
    if (onOsChange != null) {
      onOsChange(os ? os : undefined);
    }
  }, [onOsChange]);
  const osSingleSelectionOptions = (0, _react.useMemo)(() => {
    return {
      asPlainText: true
    };
  }, []);
  const selectedOStoOptions = (0, _react.useMemo)(() => {
    return OS_OPTIONS.filter(option => {
      return selectedOs === option.value;
    });
  }, [selectedOs]);
  const isExceptionBuilderFormDisabled = (0, _react.useMemo)(() => {
    return showOsTypeOptions && selectedOs === undefined;
  }, [showOsTypeOptions, selectedOs]);
  const osDisplay = osTypes => {
    const translateOS = currentOs => {
      return currentOs === 'linux' ? sharedI18n.OPERATING_SYSTEM_LINUX : currentOs === 'macos' ? sharedI18n.OPERATING_SYSTEM_MAC : sharedI18n.OPERATING_SYSTEM_WINDOWS;
    };
    return osTypes.reduce((osString, currentOs) => {
      return `${translateOS(currentOs)}, ${osString}`;
    }, '').slice(0, -2);
  };
  const eqlCalloutWarning = (0, _react.useMemo)(() => {
    return isEdit ? i18n.EDIT_EXCEPTION_SEQUENCE_WARNING : i18n.ADD_EXCEPTION_SEQUENCE_WARNING;
  }, [isEdit]);
  const osTypes = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = isEdit ? exceptionListItems[0].os_types : selectedOs) !== null && _ref !== void 0 ? _ref : [];
  }, [exceptionListItems, isEdit, selectedOs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SectionHeader, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 9
    }
  }, i18n.RULE_EXCEPTION_CONDITIONS)), includesRuleWithEQLSequenceStatement && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "eqlSequenceCallout",
    title: eqlCalloutWarning,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }, i18n.EXCEPTION_BUILDER_INFO), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }), showOsTypeOptions && !isEdit && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: sharedI18n.OPERATING_SYSTEM_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: i18n.OPERATING_SYSTEM_PLACEHOLDER,
    singleSelection: osSingleSelectionOptions,
    options: OS_OPTIONS,
    selectedOptions: selectedOStoOptions,
    onChange: handleOSSelectionChange,
    isClearable: false,
    "data-test-subj": "osSelectionDropdown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  })), showOsTypeOptions && isEdit && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "exceptionItemSelectedOs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("dl", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("dt", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 15
    }
  }, sharedI18n.OPERATING_SYSTEM_LABEL), /*#__PURE__*/_react.default.createElement("dd", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 15
    }
  }, osDisplay(osTypes)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  })), (0, _public.getExceptionBuilderComponentLazy)({
    allowLargeValueLists,
    httpService: http,
    autocompleteService: unifiedSearch.autocomplete,
    exceptionListItems,
    listType: exceptionListType,
    osTypes,
    listId: listIdToUse,
    listNamespaceType,
    exceptionItemName,
    indexPatterns,
    isOrDisabled: isExceptionBuilderFormDisabled,
    isAndDisabled: isExceptionBuilderFormDisabled,
    isNestedDisabled: isExceptionBuilderFormDisabled,
    dataTestSubj: 'alertExceptionBuilder',
    idAria: 'alertExceptionBuilder',
    onChange: handleBuilderOnChange,
    isDisabled: isExceptionBuilderFormDisabled,
    allowCustomFieldOptions: !isEndpointException,
    getExtendedFields,
    showValueListModal: _show_value_list_modal.ShowValueListModal
  }));
};
const ExceptionsConditions = exports.ExceptionsConditions = /*#__PURE__*/_react.default.memo(ExceptionsConditionsComponent);
ExceptionsConditions.displayName = 'ExceptionsConditions';