"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemCardMetaInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _components = require("../../../../exceptions/components");
var i18n = _interopRequireWildcard(require("./translations"));
var _formatted_date = require("../../../../common/components/formatted_date");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/exception_item_card/meta.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExceptionItemCardMetaInfo = exports.ExceptionItemCardMetaInfo = /*#__PURE__*/(0, _react.memo)(({
  item,
  listAndReferences,
  dataTestSubj
}) => {
  const [isListsPopoverOpen, setIsListsPopoverOpen] = (0, _react.useState)(false);
  const [isRulesPopoverOpen, setIsRulesPopoverOpen] = (0, _react.useState)(false);
  const onAffectedRulesClick = () => setIsRulesPopoverOpen(isOpen => !isOpen);
  const onAffectedListsClick = () => setIsListsPopoverOpen(isOpen => !isOpen);
  const onCloseRulesPopover = () => setIsRulesPopoverOpen(false);
  const onClosListsPopover = () => setIsListsPopoverOpen(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const metaInfoItemStyles = (0, _react2.css)`
      border-right: ${euiTheme.border.thin};
      padding: ${euiTheme.size.xs} ${euiTheme.size.m} ${euiTheme.size.xs} 0;
    `;
  const referenceLinksContainerStyles = (0, _react2.css)`
      div {
        color: ${euiTheme.colors.textPrimary};
        padding: ${euiTheme.size.s};

        &:not(:last-child) {
          border-bottom: ${euiTheme.border.thin};
        }
      }
    `;
  const isExpired = (0, _react.useMemo)(() => item.expire_time ? new Date(item.expire_time) <= new Date() : false, [item]);
  const itemActions = (0, _react.useMemo)(() => {
    if (listAndReferences == null) {
      return [];
    }
    return listAndReferences.referenced_rules.map(reference => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": `${dataTestSubj}-rulesAffected-${reference.id}`,
      key: reference.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: reference.name,
      anchorClassName: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_components.LinkToRuleDetails, {
      external: true,
      referenceId: reference.id,
      referenceName: reference.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 13
      }
    }))));
  }, [listAndReferences, dataTestSubj]);
  const rulesAffected = (0, _react.useMemo)(() => {
    var _listAndReferences$re;
    if (listAndReferences == null) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: metaInfoItemStyles,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: onAffectedRulesClick,
        iconType: "list",
        "data-test-subj": `${dataTestSubj}-affectedRulesButton`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 15
        }
      }, i18n.AFFECTED_RULES((_listAndReferences$re = listAndReferences === null || listAndReferences === void 0 ? void 0 : listAndReferences.referenced_rules.length) !== null && _listAndReferences$re !== void 0 ? _listAndReferences$re : 0)),
      panelPaddingSize: "none",
      isOpen: isRulesPopoverOpen,
      closePopover: onCloseRulesPopover,
      "data-test-subj": `${dataTestSubj}-rulesPopover`,
      id: 'rulesPopover',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      css: referenceLinksContainerStyles,
      items: itemActions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    })));
  }, [listAndReferences, metaInfoItemStyles, dataTestSubj, isRulesPopoverOpen, referenceLinksContainerStyles, itemActions]);
  const listsAffected = (0, _react.useMemo)(() => {
    if (listAndReferences == null) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    if (listAndReferences.type !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          onClick: onAffectedListsClick,
          iconType: "list",
          "data-test-subj": `${dataTestSubj}-affectedListsButton`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 125,
            columnNumber: 17
          }
        }, i18n.AFFECTED_LIST),
        panelPaddingSize: "none",
        isOpen: isListsPopoverOpen,
        closePopover: onClosListsPopover,
        "data-test-subj": `${dataTestSubj}-listsPopover`,
        id: 'listsPopover',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        size: "s",
        css: referenceLinksContainerStyles,
        items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          "data-test-subj": `${dataTestSubj}-listsAffected-${listAndReferences.id}`,
          key: listAndReferences.id,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 143,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: listAndReferences.name,
          anchorClassName: "eui-textTruncate",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 147,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_components.LinkToListDetails, {
          dataTestSubj: "link-to-exception-list",
          linkTitle: listAndReferences.name,
          listId: listAndReferences === null || listAndReferences === void 0 ? void 0 : listAndReferences.list_id,
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 148,
            columnNumber: 23
          }
        })))],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 15
        }
      })));
    } else {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
  }, [listAndReferences, dataTestSubj, isListsPopoverOpen, referenceLinksContainerStyles]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: metaInfoItemStyles,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(MetaInfoDetails, {
    fieldName: "created_by",
    label: i18n.EXCEPTION_ITEM_CREATED_LABEL,
    value1: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      fieldName: "created_at",
      value: item.created_at,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 21
      }
    }),
    value2: item.created_by,
    dataTestSubj: `${dataTestSubj}-createdBy`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: metaInfoItemStyles,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(MetaInfoDetails, {
    fieldName: "updated_by",
    label: i18n.EXCEPTION_ITEM_UPDATED_LABEL,
    value1: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      fieldName: "updated_at",
      value: item.updated_at,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 21
      }
    }),
    value2: item.updated_by,
    dataTestSubj: `${dataTestSubj}-updatedBy`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  })), item.expire_time != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: metaInfoItemStyles,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(MetaInfoDetails, {
    fieldName: "expire_time",
    label: isExpired ? i18n.EXCEPTION_ITEM_EXPIRED_LABEL : i18n.EXCEPTION_ITEM_EXPIRES_LABEL,
    value1: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      fieldName: "expire_time",
      value: item.expire_time,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 25
      }
    }),
    dataTestSubj: `${dataTestSubj}-expireTime`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  }))), listAndReferences != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rulesAffected, listsAffected));
});
ExceptionItemCardMetaInfo.displayName = 'ExceptionItemCardMetaInfo';
const MetaInfoDetails = /*#__PURE__*/(0, _react.memo)(({
  label,
  value1,
  value2,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    wrap: false,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: {
      fontFamily: 'Inter'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `${dataTestSubj}-value1`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    css: {
      fontFamily: 'Inter'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 9
    }
  }, value1)), value2 != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: {
      fontFamily: 'Inter'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 13
    }
  }, i18n.EXCEPTION_ITEM_META_BY)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `${dataTestSubj}-value2`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    wrap: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    css: {
      fontFamily: 'Inter'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 17
    }
  }, value2))))));
});
MetaInfoDetails.displayName = 'MetaInfoDetails';