"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemCard = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _helpers = require("../../utils/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _header = require("./header");
var _conditions = require("./conditions");
var _meta = require("./meta");
var _comments = require("./comments");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/exception_item_card/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExceptionItemCardComponent = ({
  disableActions,
  exceptionItem,
  isEndpoint,
  listAndReferences,
  onDeleteException,
  onEditException,
  dataTestSubj
}) => {
  const handleDelete = (0, _react.useCallback)(() => {
    onDeleteException({
      id: exceptionItem.id,
      name: exceptionItem.name,
      namespaceType: exceptionItem.namespace_type
    });
  }, [onDeleteException, exceptionItem.id, exceptionItem.name, exceptionItem.namespace_type]);
  const handleEdit = (0, _react.useCallback)(() => {
    onEditException(exceptionItem);
  }, [onEditException, exceptionItem]);
  const formattedComments = (0, _react.useMemo)(() => {
    return (0, _helpers.getFormattedComments)(exceptionItem.comments);
  }, [exceptionItem.comments]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    "data-test-subj": dataTestSubj,
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `${dataTestSubj}-header`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header.ExceptionItemCardHeader, {
    item: exceptionItem,
    actions: [{
      key: 'edit',
      icon: 'controlsHorizontal',
      label: isEndpoint ? i18n.ENDPOINT_EXCEPTION_ITEM_EDIT_BUTTON : i18n.EXCEPTION_ITEM_EDIT_BUTTON,
      onClick: handleEdit
    }, {
      key: 'delete',
      icon: 'trash',
      label: isEndpoint ? i18n.ENDPOINT_EXCEPTION_ITEM_DELETE_BUTTON : i18n.EXCEPTION_ITEM_DELETE_BUTTON,
      onClick: handleDelete
    }],
    disableActions: disableActions,
    dataTestSubj: "exceptionItemCardHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `${dataTestSubj}-meta`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_meta.ExceptionItemCardMetaInfo, {
    item: exceptionItem,
    listAndReferences: listAndReferences,
    dataTestSubj: "exceptionItemCardMetaInfo",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_conditions.ExceptionItemCardConditions, {
    os: exceptionItem.os_types,
    entries: exceptionItem.entries,
    dataTestSubj: "exceptionItemCardConditions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })), formattedComments.length > 0 && /*#__PURE__*/_react.default.createElement(_comments.ExceptionItemCardComments, {
    comments: formattedComments,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 42
    }
  })));
};
ExceptionItemCardComponent.displayName = 'ExceptionItemCardComponent';
const ExceptionItemCard = exports.ExceptionItemCard = /*#__PURE__*/_react.default.memo(ExceptionItemCardComponent);
ExceptionItemCard.displayName = 'ExceptionItemCard';