"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlQueryEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@kbn/react-query");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _shared_imports = require("../../../../shared_imports");
var _query_bar_field = require("../../../rule_creation_ui/components/query_bar_field");
var _esql_query_required_validator = require("./validators/esql_query_required_validator");
var _esql_query_validator_factory = require("./validators/esql_query_validator_factory");
var _esql_info_icon = require("./esql_info_icon");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/esql_query_edit/esql_query_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EsqlQueryEdit = exports.EsqlQueryEdit = /*#__PURE__*/(0, _react.memo)(function EsqlQueryEdit({
  path,
  fieldsToValidateOnChange,
  dataView,
  required = false,
  loading = false,
  disabled = false,
  onValidityChange
}) {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const componentProps = (0, _react.useMemo)(() => ({
    isDisabled: disabled,
    isLoading: loading,
    indexPattern: dataView,
    idAria: 'ruleEsqlQueryBar',
    dataTestSubj: 'ruleEsqlQueryBar',
    onValidityChange
  }), [dataView, loading, disabled, onValidityChange]);
  const fieldConfig = (0, _react.useMemo)(() => ({
    label: i18n.ESQL_QUERY,
    labelAppend: /*#__PURE__*/_react.default.createElement(_esql_info_icon.EsqlInfoIcon, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 20
      }
    }),
    fieldsToValidateOnChange: fieldsToValidateOnChange ? [path, fieldsToValidateOnChange].flat() : undefined,
    validations: [...(required ? [{
      validator: _esql_query_required_validator.esqlQueryRequiredValidator
    }] : []), {
      validator: (0, _securitysolutionUtils.debounceAsync)((0, _esql_query_validator_factory.esqlQueryValidatorFactory)({
        queryClient
      }), 300),
      isAsync: true
    }]
  }), [required, path, fieldsToValidateOnChange, queryClient]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: path,
    component: _query_bar_field.QueryBarField,
    componentProps: componentProps,
    config: fieldConfig,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
});