"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSuppressionEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _missing_fields_strategy_selector = require("./missing_fields_strategy_selector");
var _suppression_duration_selector = require("./suppression_duration_selector");
var _suppression_fields_selector = require("./suppression_fields_selector");
var _fields = require("../constants/fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/alert_suppression_edit/components/alert_suppression_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertSuppressionEdit = exports.AlertSuppressionEdit = /*#__PURE__*/(0, _react.memo)(function AlertSuppressionEdit({
  suppressibleFields,
  labelAppend,
  disabled,
  disabledText,
  warningText,
  fullWidth
}) {
  const [{
    [_fields.ALERT_SUPPRESSION_FIELDS_FIELD_NAME]: suppressionFields
  }] = (0, _shared_imports.useFormData)({
    watch: _fields.ALERT_SUPPRESSION_FIELDS_FIELD_NAME
  });
  const hasSelectedFields = (suppressionFields === null || suppressionFields === void 0 ? void 0 : suppressionFields.length) > 0;
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_suppression_fields_selector.SuppressionFieldsSelector, {
    suppressibleFields: suppressibleFields,
    labelAppend: labelAppend,
    disabled: disabled,
    fullWidth: fullWidth,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }), warningText && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "warning",
    "data-test-subj": "alertSuppressionWarning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, warningText), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_suppression_duration_selector.SuppressionDurationSelector, {
    disabled: disabled || !hasSelectedFields,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_missing_fields_strategy_selector.MissingFieldsStrategySelector, {
    disabled: disabled || !hasSelectedFields,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: disabled && disabledText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, content);
});