"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSecurityRoutePageWrapper = exports.SecurityRoutePageWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/usage-collection-plugin/public");
var _common = require("../../../../common");
var _links = require("../../links");
var _no_privileges = require("../no_privileges");
var _use_upselling = require("../../hooks/use_upselling");
var _spy_routes = require("../../utils/route/spy_routes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/security_route_page_wrapper/security_route_page_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const deprectedPagesWithRedirect = [_common.SecurityPageName.detections];

/**
 * This component is created to wrap all the pages in the security solution app.
 *
 * It handles application tracking and upselling.
 *
 * When using this component make sure it render bellow `SecurityPageWrapper` and
 * that you removed the `TrackApplicationView` component.
 *
 * Ex:
 * ```
 * <PluginTemplateWrapper>
 *   <SecurityRoutePageWrapper pageName={SecurityPageName.myPage}>
 *     <MyPage />
 *   </SecurityRoutePageWrapper>
 * </PluginTemplateWrapper>
 * ```
 */
const SecurityRoutePageWrapper = exports.SecurityRoutePageWrapper = /*#__PURE__*/_react.default.memo(({
  children,
  pageName,
  omitSpyRoute = false
}) => {
  const link = (0, _links.useLinkInfo)(pageName);
  const UpsellingPage = (0, _use_upselling.useUpsellingPage)(pageName);

  // The upselling page is only returned when the license/product requirements are not met.
  // When it is defined it must be rendered, no need to check anything else.
  if (UpsellingPage) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
      pageName: pageName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(UpsellingPage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }));
  }

  // Redirect to the home page if the link does not exist in the application links (has been filtered out).
  // or if the link is unavailable (payment plan not met, if it had upselling page associated it would have been rendered above).
  // Some pages handle their own redirect logic, so we need to exclude them from this check.
  if (!deprectedPagesWithRedirect.includes(pageName) && (link == null || link.unavailable)) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: "",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 14
      }
    });
  }

  // Show the no privileges page if the link is unauthorized.
  if (link && link.unauthorized) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
      pageName: pageName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivilegesPage, {
      pageName: pageName,
      docLinkSelector: docLinks => docLinks.siem.privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: pageName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, children, !omitSpyRoute && /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: pageName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 27
    }
  }));
});
SecurityRoutePageWrapper.displayName = 'SecurityRoutePageWrapper';

/**
 * HOC to wrap a component with the `SecurityRoutePageWrapper`.
 */
const withSecurityRoutePageWrapper = (Component, pageName, options = {}) => {
  return /*#__PURE__*/_react.default.memo(function WithSecurityRoutePageWrapper(props) {
    return /*#__PURE__*/_react.default.createElement(SecurityRoutePageWrapper, (0, _extends2.default)({
      pageName: pageName
    }, options, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    })));
  });
};
exports.withSecurityRoutePageWrapper = withSecurityRoutePageWrapper;