"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleName = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/rule_name/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const appendSearch = search => (0, _lodash.isEmpty)(search) ? '' : `${search !== null && search !== void 0 && search.startsWith('?') ? search : `?${search}`}`;
const RuleNameComponents = ({
  name,
  id,
  appId
}) => {
  const {
    navigateToApp,
    getUrlForApp
  } = (0, _public.useKibana)().services.application;
  const hrefRuleDetails = (0, _react.useMemo)(() => getUrlForApp(appId, {
    deepLinkId: 'rules',
    path: `/id/${id}${appendSearch(window.location.search)}`
  }), [getUrlForApp, id, appId]);
  const goToRuleDetails = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(appId, {
      deepLinkId: 'rules',
      path: `/id/${id}${appendSearch(window.location.search)}`
    });
  }, [navigateToApp, id, appId]);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, {
      href: hrefRuleDetails,
      onClick: goToRuleDetails,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 5
      }
    }, name)
  );
};
const RuleName = exports.RuleName = /*#__PURE__*/_react.default.memo(RuleNameComponents);