"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.missingPrivilegesCallOutBody = exports.PRIVILEGES_REQUIRED_TITLE = exports.PRIVILEGES_MISSING_TITLE = exports.MISSING_PRIVILEGES_CALLOUT_TITLE = exports.CONTACT_ADMINISTRATOR = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../common/constants");
var _comma_separated_values = require("./comma_separated_values");
var _links_to_docs = require("../links_to_docs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/missing_privileges/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PRIVILEGES_MISSING_TITLE = exports.PRIVILEGES_MISSING_TITLE = _i18n.i18n.translate('xpack.securitySolution.common.onboarding.assistantCard.missingPrivileges.title', {
  defaultMessage: 'Missing privileges'
});
const PRIVILEGES_REQUIRED_TITLE = exports.PRIVILEGES_REQUIRED_TITLE = _i18n.i18n.translate('xpack.securitySolution.common.onboarding.assistantCard.requiredPrivileges', {
  defaultMessage: 'The minimum Kibana privileges required to use this feature are:'
});
const CONTACT_ADMINISTRATOR = exports.CONTACT_ADMINISTRATOR = _i18n.i18n.translate('xpack.securitySolution.common.onboarding.assistantCard.missingPrivileges.contactAdministrator', {
  defaultMessage: 'Contact your administrator for assistance.'
});
const MISSING_PRIVILEGES_CALLOUT_TITLE = exports.MISSING_PRIVILEGES_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.common.missingPrivilegesCallOut.messageTitle', {
  defaultMessage: 'Insufficient privileges'
});
const CANNOT_EDIT_RULES = _i18n.i18n.translate('xpack.securitySolution.common.missingPrivilegesCallOut.cannotEditRules', {
  defaultMessage: 'Without that privilege you cannot create or edit detection engine rules.'
});
const CANNOT_EDIT_LISTS = _i18n.i18n.translate('xpack.securitySolution.common.missingPrivilegesCallOut.cannotEditLists', {
  defaultMessage: 'Without these privileges, you cannot create or edit value lists.'
});
const CANNOT_EDIT_ALERTS = _i18n.i18n.translate('xpack.securitySolution.common.missingPrivilegesCallOut.cannotEditAlerts', {
  defaultMessage: 'Without these privileges, you cannot view or change status of alerts.'
});
const missingPrivilegesCallOutBody = ({
  indexPrivileges,
  featurePrivileges = []
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.common.missingPrivilegesCallOut.messageBody.messageDetail",
  defaultMessage: "{essence} {indexPrivileges} {featurePrivileges} Related documentation: {docs}",
  values: {
    essence: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.common.missingPrivilegesCallOut.messageBody.essenceDescription",
      defaultMessage: "You need the following privileges to fully access this functionality. Contact your administrator for further assistance.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    })),
    indexPrivileges: indexPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.common.missingPrivilegesCallOut.messageBody.indexPrivilegesTitle",
      defaultMessage: "Missing Elasticsearch index privileges:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, indexPrivileges.map(([index, missingPrivileges]) => /*#__PURE__*/_react.default.createElement("li", {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 17
      }
    }, missingPrivilegesMessage(index, missingPrivileges))))) : null,
    featurePrivileges: featurePrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.common.missingPrivilegesCallOut.messageBody.featurePrivilegesTitle",
      defaultMessage: "Missing Kibana feature privileges:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    }, featurePrivileges.map(([feature, missingPrivileges]) => /*#__PURE__*/_react.default.createElement("li", {
      key: feature,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 17
      }
    }, missingFeaturePrivileges(feature, missingPrivileges))))) : null,
    docs: /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("li", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_links_to_docs.DetectionsRequirementsLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_links_to_docs.SecuritySolutionRequirementsLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 13
      }
    })))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 3
  }
});
exports.missingPrivilegesCallOutBody = missingPrivilegesCallOutBody;
const PRIVILEGE_EXPLANATIONS = {
  [_constants.SECURITY_FEATURE_ID]: {
    all: CANNOT_EDIT_RULES
  },
  [_constants.DEFAULT_SIGNALS_INDEX]: {
    write: CANNOT_EDIT_ALERTS
  },
  [_constants.DEFAULT_LISTS_INDEX]: {
    write: CANNOT_EDIT_LISTS
  },
  [_constants.DEFAULT_ITEMS_INDEX]: {
    write: CANNOT_EDIT_LISTS
  }
};
const getPrivilegesExplanation = (missingPrivileges, index) => {
  var _Object$entries$find;
  const explanationsByPrivilege = (_Object$entries$find = Object.entries(PRIVILEGE_EXPLANATIONS).find(([key]) => index.startsWith(key))) === null || _Object$entries$find === void 0 ? void 0 : _Object$entries$find[1];
  return missingPrivileges.map(privilege => explanationsByPrivilege === null || explanationsByPrivilege === void 0 ? void 0 : explanationsByPrivilege[privilege]).filter(Boolean).join(' ');
};
const missingPrivilegesMessage = (index, privileges) => {
  // .lists and .items are data streams, so we will show it in the message
  if ([_constants.DEFAULT_LISTS_INDEX, _constants.DEFAULT_ITEMS_INDEX].some(dataStreamName => index.startsWith(dataStreamName))) {
    return missingDataStreamPrivileges(index, privileges);
  }
  return missingIndexPrivileges(index, privileges);
};
const missingIndexPrivileges = (index, privileges) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.common.missingPrivilegesCallOut.messageBody.missingIndexPrivileges",
  defaultMessage: "Missing {privileges} privileges for the {index} index. {explanation}",
  values: {
    privileges: /*#__PURE__*/_react.default.createElement(_comma_separated_values.CommaSeparatedValues, {
      values: privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 19
      }
    }),
    index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 14
      }
    }, index),
    explanation: getPrivilegesExplanation(privileges, index)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 175,
    columnNumber: 3
  }
});
const missingDataStreamPrivileges = (dataStream, privileges) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.common.missingPrivilegesCallOut.messageBody.missingDataStreamPrivileges",
  defaultMessage: "Missing {privileges} privileges for the {dataStream} data stream. {explanation}",
  values: {
    privileges: /*#__PURE__*/_react.default.createElement(_comma_separated_values.CommaSeparatedValues, {
      values: privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 19
      }
    }),
    dataStream: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 19
      }
    }, dataStream),
    explanation: getPrivilegesExplanation(privileges, dataStream)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 187,
    columnNumber: 3
  }
});
const missingFeaturePrivileges = (feature, privileges) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.common.missingPrivilegesCallOut.messageBody.missingFeaturePrivileges",
  defaultMessage: "Missing {privileges} privileges for the {index} feature. {explanation}",
  values: {
    privileges: /*#__PURE__*/_react.default.createElement(_comma_separated_values.CommaSeparatedValues, {
      values: privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 19
      }
    }),
    index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 14
      }
    }, feature),
    explanation: getPrivilegesExplanation(privileges, feature)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 199,
    columnNumber: 3
  }
});