"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _search_strategy = require("../../../common/search_strategy");
var _utils = require("../../entity_analytics/common/utils");
var _risk_levels = require("../../../common/entity_analytics/risk_engine/risk_levels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/risk_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const tooltips = {
  [_search_strategy.RiskSeverity.Unknown]: _i18n.i18n.translate('xpack.securitySolution.assetInventory.allAssets.risks.unknown', {
    defaultMessage: _search_strategy.RiskSeverity.Unknown
  }),
  [_search_strategy.RiskSeverity.Low]: _i18n.i18n.translate('xpack.securitySolution.assetInventory.allAssets.risks.low', {
    defaultMessage: _search_strategy.RiskSeverity.Low
  }),
  [_search_strategy.RiskSeverity.Moderate]: _i18n.i18n.translate('xpack.securitySolution.assetInventory.allAssets.risks.moderate', {
    defaultMessage: _search_strategy.RiskSeverity.Moderate
  }),
  [_search_strategy.RiskSeverity.High]: _i18n.i18n.translate('xpack.securitySolution.assetInventory.allAssets.risks.high', {
    defaultMessage: _search_strategy.RiskSeverity.High
  }),
  [_search_strategy.RiskSeverity.Critical]: _i18n.i18n.translate('xpack.securitySolution.assetInventory.allAssets.risks.critical', {
    defaultMessage: _search_strategy.RiskSeverity.Critical
  })
};
const RiskBadge = ({
  risk,
  ...props
}) => {
  const riskLevel = (0, _risk_levels.getRiskLevel)(risk);
  const color = _utils.RISK_SEVERITY_COLOUR[riskLevel];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltips[riskLevel],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({}, props, {
    tabIndex: 0,
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), risk));
};
exports.RiskBadge = RiskBadge;