"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCopyToClipboardDiscoverCellActionFactory = void 0;
var _is_in_security_app = require("../../../../common/hooks/is_in_security_app");
var _copy_to_clipboard = require("../cell_action/copy_to_clipboard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCopyToClipboardDiscoverCellActionFactory = ({
  services
}) => {
  const {
    application
  } = services;
  let currentAppId;
  application.currentAppId$.subscribe(appId => {
    currentAppId = appId;
  });
  const genericCopyToClipboardActionFactory = (0, _copy_to_clipboard.createCopyToClipboardCellActionFactory)({
    services
  });
  return genericCopyToClipboardActionFactory.combine({
    isCompatible: async () => (0, _is_in_security_app.isInSecurityApp)(currentAppId)
  });
};
exports.createCopyToClipboardDiscoverCellActionFactory = createCopyToClipboardDiscoverCellActionFactory;