"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeDisplay = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _securityUiComponents = require("@kbn/security-ui-components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/kibana/space_aware_privilege_section/privilege_display.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PrivilegeDisplay = props => {
  return /*#__PURE__*/_react.default.createElement(SimplePrivilegeDisplay, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 10
    }
  }));
};
exports.PrivilegeDisplay = PrivilegeDisplay;
const SimplePrivilegeDisplay = props => {
  const {
    privilege,
    ...rest
  } = props;
  const text = /*#__PURE__*/_react.default.createElement(_eui.EuiText, (0, _extends2.default)({}, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 16
    }
  }), getDisplayValue(privilege));
  return text;
};
PrivilegeDisplay.defaultProps = {
  privilege: []
};
function getDisplayValue(privilege) {
  const privileges = coerceToArray(privilege);
  let displayValue;
  const isPrivilegeMissing = privileges.length === 0 || privileges.length === 1 && privileges.includes(_securityUiComponents.constants.NO_PRIVILEGE_VALUE);
  if (isPrivilegeMissing) {
    displayValue = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: 'minusInCircle',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 20
      }
    });
  } else {
    displayValue = privileges.map(p => _lodash.default.upperFirst(p)).join(', ');
  }
  return displayValue;
}
function coerceToArray(privilege) {
  if (privilege === undefined) {
    return [];
  }
  if (Array.isArray(privilege)) {
    return privilege;
  }
  return [privilege];
}