"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptAllRule = void 0;
var _i18n = require("@kbn/i18n");
var _rule_group = require("./rule_group");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Represents a group of rules in which at least one must evaluate to false.
 */
class ExceptAllRule extends _rule_group.RuleGroup {
  constructor(rules = []) {
    super();
    this.rules = rules;
  }

  /** {@see RuleGroup.getRules} */
  getRules() {
    return [...this.rules];
  }

  /** {@see RuleGroup.getDisplayTitle} */
  getDisplayTitle() {
    return _i18n.i18n.translate('xpack.security.management.editRoleMapping.exceptAllRule.displayTitle', {
      defaultMessage: 'Any are false'
    });
  }

  /** {@see RuleGroup.replaceRule} */
  replaceRule(ruleIndex, rule) {
    this.rules.splice(ruleIndex, 1, rule);
  }

  /** {@see RuleGroup.removeRule} */
  removeRule(ruleIndex) {
    this.rules.splice(ruleIndex, 1);
  }

  /** {@see RuleGroup.addRule} */
  addRule(rule) {
    this.rules.push(rule);
  }

  /** {@see RuleGroup.canContainRules} */
  canContainRules() {
    return true;
  }

  /** {@see RuleGroup.clone} */
  clone() {
    return new ExceptAllRule(this.rules.map(r => r.clone()));
  }

  /** {@see RuleGroup.toRaw} */
  toRaw() {
    const rawRule = {
      all: [...this.rules.map(rule => rule.toRaw())]
    };
    return {
      except: rawRule
    };
  }
}
exports.ExceptAllRule = ExceptAllRule;