"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentSelector = void 0;
var _eui = require("@elastic/eui");
var _searchIndexDocuments = require("@kbn/search-index-documents");
var _result_metadata = require("@kbn/search-index-documents/components/result/result_metadata");
var _react = _interopRequireDefault(require("react"));
var _use_fetch_document = require("../../../../hooks/use_fetch_document");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/query_ruleset_detail/query_rule_flyout/document_selector/document_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DocumentSelector = ({
  initialDocId = '',
  index = '',
  indexDoc = undefined,
  type = undefined,
  onDeleteDocument = () => {},
  onIdSelectorChange = () => {},
  onIndexSelectorChange = () => {},
  indices = [],
  hasIndexSelector = true,
  error: formError
}) => {
  var _fetchDocumentError$b;
  const {
    data,
    error: fetchDocumentError,
    isError,
    isLoading
  } = (0, _use_fetch_document.useFetchDocument)(index, initialDocId);
  const {
    document,
    mappings
  } = data || {};
  // Otherwise it will show loading until first document is fetched
  const showLoading = Boolean(isLoading && index && initialDocId);
  const error = isError ? fetchDocumentError === null || fetchDocumentError === void 0 ? void 0 : (_fetchDocumentError$b = fetchDocumentError.body) === null || _fetchDocumentError$b === void 0 ? void 0 : _fetchDocumentError$b.message : formError ? formError === null || formError === void 0 ? void 0 : formError.message : undefined;
  return /*#__PURE__*/_react.default.createElement(_searchIndexDocuments.EditableResult, {
    initialDocId: initialDocId,
    initialIndex: index,
    leftSideItem: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, type === 'pinned' && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "transparent",
      paddingSize: "s",
      "aria-label": "Drag Handle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      direction: "row",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "grab",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 19
      }
    }, (indexDoc !== null && indexDoc !== void 0 ? indexDoc : 0) + 1))))),
    "data-test-subj": "searchQueryRulesQueryRuleFlyoutDocumentCount",
    indices: indices,
    hasIndexSelector: hasIndexSelector,
    fields: document && (0, _result_metadata.resultToFieldFromMappingResponse)(document, mappings),
    onIdSelectorChange: onIdSelectorChange,
    onIndexSelectorChange: onIndexSelectorChange,
    onDeleteDocument: onDeleteDocument,
    isLoading: showLoading,
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
};
exports.DocumentSelector = DocumentSelector;