"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildNewSavedPlaygroundFromForm = buildNewSavedPlaygroundFromForm;
exports.buildSavedPlaygroundFromForm = buildSavedPlaygroundFromForm;
exports.fetchSavedPlaygroundError = fetchSavedPlaygroundError;
exports.hasSavedPlaygroundFormErrors = hasSavedPlaygroundFormErrors;
exports.isSavedPlaygroundFormDirty = isSavedPlaygroundFormDirty;
exports.parseSavedPlayground = parseSavedPlayground;
exports.validatePlaygroundName = validatePlaygroundName;
exports.validateSavedPlaygroundIndices = validateSavedPlaygroundIndices;
exports.validateSavedPlaygroundModel = validateSavedPlaygroundModel;
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
var _prompt = require("../../common/prompt");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function parseSummarizationModel(model, models) {
  if (!model) {
    return undefined;
  }
  if (model.modelId) {
    const exactMatch = models.find(llm => llm.connectorId === model.connectorId && llm.value === model.modelId);
    if (exactMatch) {
      return exactMatch;
    }
  }
  return models.find(llm => llm.connectorId === model.connectorId);
}
function parseSavedPlayground(playground, models) {
  var _playground$data$user, _playground$data$prom, _playground$data$cita, _ref, _playground$data$cont, _playground$data$cont2, _playground$data$cont3;
  return {
    [_types.SavedPlaygroundFormFields.name]: playground.data.name,
    [_types.SavedPlaygroundFormFields.indices]: playground.data.indices,
    [_types.SavedPlaygroundFormFields.queryFields]: playground.data.queryFields,
    [_types.SavedPlaygroundFormFields.elasticsearchQuery]: JSON.parse(playground.data.elasticsearchQueryJSON),
    // TODO: replace with function
    [_types.SavedPlaygroundFormFields.userElasticsearchQuery]: (_playground$data$user = playground.data.userElasticsearchQueryJSON) !== null && _playground$data$user !== void 0 ? _playground$data$user : null,
    [_types.SavedPlaygroundFormFields.prompt]: (_playground$data$prom = playground.data.prompt) !== null && _playground$data$prom !== void 0 ? _playground$data$prom : _prompt.DEFAULT_LLM_PROMPT,
    [_types.SavedPlaygroundFormFields.citations]: (_playground$data$cita = playground.data.citations) !== null && _playground$data$cita !== void 0 ? _playground$data$cita : false,
    [_types.SavedPlaygroundFormFields.sourceFields]: (_ref = (_playground$data$cont = playground.data.context) === null || _playground$data$cont === void 0 ? void 0 : _playground$data$cont.sourceFields) !== null && _ref !== void 0 ? _ref : {},
    [_types.SavedPlaygroundFormFields.docSize]: (_playground$data$cont2 = (_playground$data$cont3 = playground.data.context) === null || _playground$data$cont3 === void 0 ? void 0 : _playground$data$cont3.docSize) !== null && _playground$data$cont2 !== void 0 ? _playground$data$cont2 : _common.DEFAULT_CONTEXT_DOCUMENTS,
    [_types.SavedPlaygroundFormFields.summarizationModel]: parseSummarizationModel(playground.data.summarizationModel, models),
    [_types.SavedPlaygroundFormFields.question]: '',
    [_types.SavedPlaygroundFormFields.searchQuery]: ''
  };
}
function fetchSavedPlaygroundError(e) {
  return {
    [_types.SavedPlaygroundFormFields.name]: '',
    [_types.SavedPlaygroundFormFields.indices]: [],
    [_types.SavedPlaygroundFormFields.queryFields]: {},
    [_types.SavedPlaygroundFormFields.elasticsearchQuery]: {
      retriever: {}
    },
    [_types.SavedPlaygroundFormFields.userElasticsearchQuery]: null,
    [_types.SavedPlaygroundFormFields.prompt]: '',
    [_types.SavedPlaygroundFormFields.citations]: false,
    [_types.SavedPlaygroundFormFields.sourceFields]: {},
    [_types.SavedPlaygroundFormFields.docSize]: 0,
    [_types.SavedPlaygroundFormFields.summarizationModel]: undefined,
    [_types.SavedPlaygroundFormFields.question]: '',
    [_types.SavedPlaygroundFormFields.searchQuery]: '',
    error: e instanceof Error ? e : new Error(String(e))
  };
}
const SavedPlaygroundFields = [_types.SavedPlaygroundFormFields.name, _types.SavedPlaygroundFormFields.indices, _types.SavedPlaygroundFormFields.queryFields, _types.SavedPlaygroundFormFields.elasticsearchQuery, _types.SavedPlaygroundFormFields.userElasticsearchQuery, _types.SavedPlaygroundFormFields.prompt, _types.SavedPlaygroundFormFields.citations, _types.SavedPlaygroundFormFields.sourceFields, _types.SavedPlaygroundFormFields.docSize, _types.SavedPlaygroundFormFields.summarizationModel];
function isSavedPlaygroundFormDirty(formDirtyFields) {
  const dirtyFields = Object.entries(formDirtyFields).filter(([_key, value]) => typeof value === 'boolean' && value === true).map(([key]) => key);
  return SavedPlaygroundFields.some(field => dirtyFields.includes(field));
}
const SavedPlaygroundFieldErrors = [_types.SavedPlaygroundFormFields.name, _types.SavedPlaygroundFormFields.indices, _types.SavedPlaygroundFormFields.queryFields, _types.SavedPlaygroundFormFields.elasticsearchQuery, _types.SavedPlaygroundFormFields.userElasticsearchQuery, _types.SavedPlaygroundFormFields.prompt, _types.SavedPlaygroundFormFields.citations, _types.SavedPlaygroundFormFields.sourceFields, _types.SavedPlaygroundFormFields.docSize, _types.SavedPlaygroundFormFields.summarizationModel];
function hasSavedPlaygroundFormErrors(errors) {
  const errorFields = Object.keys(errors);
  return SavedPlaygroundFieldErrors.some(field => {
    return errorFields.includes(field);
  });
}
function buildNewSavedPlaygroundFromForm(name, formData) {
  var _formData$SavedPlaygr, _summarizationModel$v;
  const result = {
    name,
    indices: formData[_types.SavedPlaygroundFormFields.indices],
    queryFields: formData[_types.SavedPlaygroundFormFields.queryFields],
    elasticsearchQueryJSON: JSON.stringify(formData[_types.SavedPlaygroundFormFields.elasticsearchQuery]),
    userElasticsearchQueryJSON: (_formData$SavedPlaygr = formData[_types.SavedPlaygroundFormFields.userElasticsearchQuery]) !== null && _formData$SavedPlaygr !== void 0 ? _formData$SavedPlaygr : undefined
  };
  const summarizationModel = formData[_types.SavedPlaygroundFormFields.summarizationModel];
  if (!summarizationModel) {
    return result;
  }
  return {
    ...result,
    prompt: formData[_types.SavedPlaygroundFormFields.prompt],
    citations: formData[_types.SavedPlaygroundFormFields.citations],
    context: {
      sourceFields: formData[_types.SavedPlaygroundFormFields.sourceFields],
      docSize: formData[_types.SavedPlaygroundFormFields.docSize]
    },
    summarizationModel: {
      connectorId: summarizationModel.connectorId,
      modelId: (_summarizationModel$v = summarizationModel.value) !== null && _summarizationModel$v !== void 0 ? _summarizationModel$v : undefined
    }
  };
}
function buildSavedPlaygroundFromForm(formData) {
  return buildNewSavedPlaygroundFromForm(formData[_types.SavedPlaygroundFormFields.name], formData);
}
function validatePlaygroundName(name) {
  const trimmedName = name.trim();
  if (!name || !trimmedName) {
    return _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.errors.name.required', {
      defaultMessage: 'Playground name is required'
    });
  }
  if (name.length > 100) {
    return _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.errors.name.tooLong', {
      defaultMessage: 'Playground name must be less than 100 characters'
    });
  }
  return null;
}
function validateSavedPlaygroundIndices(savedIndices, queriedIndices) {
  const validIndices = [];
  const missingIndices = [];
  for (const index of savedIndices) {
    if (queriedIndices.includes(index)) {
      validIndices.push(index);
    } else {
      missingIndices.push(index);
    }
  }
  return {
    validIndices,
    missingIndices
  };
}
function validateSavedPlaygroundModel(summarizationModel, models) {
  if (summarizationModel && summarizationModel.modelId) {
    const model = models.find(llm => llm.connectorId === summarizationModel.connectorId && llm.value === summarizationModel.modelId);
    if (model === undefined) {
      return summarizationModel.modelId;
    }
  } else if (summarizationModel) {
    const model = models.find(llm => llm.connectorId === summarizationModel.connectorId);
    if (model === undefined) {
      return summarizationModel.connectorId;
    }
  }
  return undefined;
}