"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenEstimateTooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _doc_links = require("../../../common/doc_links");
var _use_llms_models = require("../../hooks/use_llms_models");
var _types = require("../../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/message_list/token_estimate_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TokenEstimateTooltip = ({
  context,
  total,
  clipped
}) => {
  const [showTooltip, setShowTooltip] = (0, _react.useState)(false);
  const models = (0, _use_llms_models.useLLMsModels)();
  const {
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const formValues = getValues(_types.PlaygroundFormFields.summarizationModel);
  const selectedModel = models.find(m => m.value === (formValues === null || formValues === void 0 ? void 0 : formValues.value));
  const toggleTooltip = () => {
    setShowTooltip(!showTooltip);
  };
  const normalContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'tokenEstimateTooltipId'
  });
  const modelLimit = selectedModel === null || selectedModel === void 0 ? void 0 : selectedModel.promptTokenLimit;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: normalContextMenuPopoverId,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "text",
      size: "xs",
      onClick: toggleTooltip,
      "data-test-subj": "token-tooltip-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.label",
      defaultMessage: "{total}{limit} tokens sent",
      values: {
        total: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 71,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
          value: total,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 72,
            columnNumber: 19
          }
        })),
        limit: modelLimit ? /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 76,
            columnNumber: 17
          }
        }, ` /`, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
          value: modelLimit,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 77,
            columnNumber: 26
          }
        })) : null
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    })),
    isOpen: showTooltip,
    closePopover: toggleTooltip,
    panelPaddingSize: "none",
    anchorPosition: "upCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      width: 300,
      items: [{
        name: /*#__PURE__*/_react.default.createElement("strong", {
          "data-test-subj": "token-tooltip-title",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.title",
          defaultMessage: "Approximate breakdown",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 21
          }
        }))
      }, {
        renderItem: () => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          paddingSize: "s",
          hasShadow: false,
          "data-test-subj": "token-tooltip-breakdown-1",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
          compressed: true,
          rowGutterSize: "s",
          columnGutterSize: "s",
          listItems: [{
            description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.contextTokens",
              defaultMessage: "Context tokens",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 120,
                columnNumber: 29
              }
            }),
            title: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
              value: context,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 125,
                columnNumber: 34
              }
            })
          }, {
            description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.instructionTokens",
              defaultMessage: "Instruction tokens",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 129,
                columnNumber: 29
              }
            }),
            title: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
              value: total - context,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 134,
                columnNumber: 34
              }
            })
          }, ...(modelLimit ? [{
            description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
              color: "subdued",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 140,
                columnNumber: 35
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.modelLimit",
              defaultMessage: "Max for this model",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 141,
                columnNumber: 37
              }
            })),
            title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
              color: "subdued",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 148,
                columnNumber: 35
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
              value: modelLimit,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 149,
                columnNumber: 37
              }
            }))
          }] : [])],
          type: "column",
          columnWidths: [2, 4],
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 21
          }
        }))
      }, {
        renderItem: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, clipped ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          paddingSize: "s",
          hasShadow: false,
          color: "warning",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 166,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          announceOnMount: true,
          "data-test-subj": "clipped-tokens-callout",
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.clippedTokensTitle",
            defaultMessage: "Context tokens exceed model limit",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 171,
              columnNumber: 29
            }
          }),
          color: "warning",
          iconType: "info",
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 167,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.clippedTokensDescription",
          defaultMessage: "Approximately {clipped} tokens within your context was removed to fit within the model's limit. Learn how to {optimizeLink} to improve your model's performance and avoid clipping.",
          values: {
            clipped: /*#__PURE__*/_react.default.createElement("strong", {
              "data-test-subj": "clipped-tokens-description",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 185,
                columnNumber: 33
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
              value: clipped,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 186,
                columnNumber: 35
              }
            })),
            optimizeLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              href: _doc_links.docLinks.retrievalOptimize,
              target: "_blank",
              "data-test-subj": "context-optimization-documentation-link",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 190,
                columnNumber: 33
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.optimizeYourIndex",
              defaultMessage: "optimize your context",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 195,
                columnNumber: 35
              }
            }))
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 180,
            columnNumber: 27
          }
        }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          paddingSize: "s",
          hasShadow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 206,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.chatPlayground,
          target: "_blank",
          "data-test-subj": "context-optimization-documentation-link",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 207,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.learnMoreLink",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 212,
            columnNumber: 27
          }
        }))))
      }]
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
};
exports.TokenEstimateTooltip = TokenEstimateTooltip;