"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetrievalDocsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/message_list/retrieval_docs_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RESULT_FIELDS_TRUNCATE_AT = 4;
const truncateFields = doc => Object.entries({
  context: doc.content,
  score: doc.metadata._score
}).slice(0, RESULT_FIELDS_TRUNCATE_AT).map(([field, value]) => ({
  field,
  value
}));
const RetrievalDocsFlyout = ({
  onClose,
  retrievalDocs
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const columns = [{
    field: 'field',
    name: _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.result.nameColumn', {
      defaultMessage: 'Field'
    }),
    render: field => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 15
        }
      }, "\"", field, "\"")));
    },
    truncateText: true,
    width: '20%'
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.result.valueColumn', {
      defaultMessage: 'Value'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "none",
      transparentBackground: true,
      fontSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, value)
  }];
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.retrievalDocsFlyoutOpened);
  }, [usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.title', {
    defaultMessage: 'Documents retrieved'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.subtitle', {
    defaultMessage: 'The documents that were referenced in order to create an answer to your query. You can change the context field using the Edit context button.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, retrievalDocs.map(doc => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    key: doc.metadata._id,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("code", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.result.id', {
    defaultMessage: 'ID: {id}',
    values: {
      id: doc.metadata._id
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("code", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.result.fromIndex', {
    defaultMessage: 'from'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 23
    }
  }, doc.metadata._index)))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: truncateFields(doc),
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  })))))));
};
exports.RetrievalDocsFlyout = RetrievalDocsFlyout;