"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tabToHumanizedMap = exports.JobDetails = exports.JOB_DETAILS_TAB_TERMS = exports.JOB_DETAILS_TAB_SUMMARY = exports.JOB_DETAILS_TAB_REQUEST = exports.JOB_DETAILS_TAB_METRICS = exports.JOB_DETAILS_TAB_JSON = exports.JOB_DETAILS_TAB_HISTOGRAM = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _tabs = require("./tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/components/job_details/job_details.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const JOB_DETAILS_TAB_SUMMARY = exports.JOB_DETAILS_TAB_SUMMARY = 'JOB_DETAILS_TAB_SUMMARY';
const JOB_DETAILS_TAB_TERMS = exports.JOB_DETAILS_TAB_TERMS = 'JOB_DETAILS_TAB_TERMS';
const JOB_DETAILS_TAB_HISTOGRAM = exports.JOB_DETAILS_TAB_HISTOGRAM = 'JOB_DETAILS_TAB_HISTOGRAM';
const JOB_DETAILS_TAB_METRICS = exports.JOB_DETAILS_TAB_METRICS = 'JOB_DETAILS_TAB_METRICS';
const JOB_DETAILS_TAB_JSON = exports.JOB_DETAILS_TAB_JSON = 'JOB_DETAILS_TAB_JSON';
const JOB_DETAILS_TAB_REQUEST = exports.JOB_DETAILS_TAB_REQUEST = 'JOB_DETAILS_TAB_REQUEST';
const tabToHumanizedMap = exports.tabToHumanizedMap = {
  [JOB_DETAILS_TAB_SUMMARY]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.create.jobDetails.tabSummaryLabel",
    defaultMessage: "Summary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }),
  [JOB_DETAILS_TAB_TERMS]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.create.jobDetails.tabTermsLabel",
    defaultMessage: "Terms",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }),
  [JOB_DETAILS_TAB_HISTOGRAM]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.create.jobDetails.tabHistogramLabel",
    defaultMessage: "Histogram",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }),
  [JOB_DETAILS_TAB_METRICS]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.create.jobDetails.tabMetricsLabel",
    defaultMessage: "Metrics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }),
  [JOB_DETAILS_TAB_JSON]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.create.jobDetails.tabJsonLabel",
    defaultMessage: "JSON",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }),
  [JOB_DETAILS_TAB_REQUEST]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.create.jobDetails.tabRequestLabel",
    defaultMessage: "Request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  })
};
const JOB_DETAILS_TABS = [JOB_DETAILS_TAB_SUMMARY, JOB_DETAILS_TAB_TERMS, JOB_DETAILS_TAB_HISTOGRAM, JOB_DETAILS_TAB_METRICS, JOB_DETAILS_TAB_JSON, JOB_DETAILS_TAB_REQUEST];
const JobDetails = ({
  tab,
  job,
  stats,
  json,
  endpoint
}) => {
  const {
    metrics,
    terms,
    histogram,
    histogramInterval
  } = job;
  const tabToContentMap = {
    [JOB_DETAILS_TAB_SUMMARY]: /*#__PURE__*/_react.default.createElement(_tabs.TabSummary, {
      job: job,
      stats: stats,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 32
      }
    }),
    [JOB_DETAILS_TAB_TERMS]: /*#__PURE__*/_react.default.createElement(_tabs.TabTerms, {
      terms: terms,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 30
      }
    }),
    [JOB_DETAILS_TAB_HISTOGRAM]: /*#__PURE__*/_react.default.createElement(_tabs.TabHistogram, {
      histogram: histogram,
      histogramInterval: histogramInterval,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }),
    [JOB_DETAILS_TAB_METRICS]: /*#__PURE__*/_react.default.createElement(_tabs.TabMetrics, {
      metrics: metrics,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 32
      }
    }),
    [JOB_DETAILS_TAB_JSON]: /*#__PURE__*/_react.default.createElement(_tabs.TabJson, {
      json: json,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 29
      }
    }),
    [JOB_DETAILS_TAB_REQUEST]: /*#__PURE__*/_react.default.createElement(_tabs.TabRequest, {
      json: json,
      endpoint: endpoint,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 32
      }
    })
  };
  return tabToContentMap[tab];
};
exports.JobDetails = JobDetails;
JobDetails.propTypes = {
  tab: _propTypes.default.oneOf(JOB_DETAILS_TABS),
  job: _propTypes.default.object
};