"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportInfoFlyoutContent = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _errors = require("@kbn/reporting-common/errors");
var _reportingPublic = require("@kbn/reporting-public");
var _constants = require("../../../common/constants");
var _shared_i18n_texts = require("../../shared_i18n_texts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/report_info_flyout_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO: Move all of these i18n texts to ./i18n_texts.tsx
const NA = _i18n.i18n.translate('xpack.reporting.listing.infoPanel.notApplicableLabel', {
  defaultMessage: 'N/A'
});
const UNKNOWN = _i18n.i18n.translate('xpack.reporting.listing.infoPanel.unknownLabel', {
  defaultMessage: 'unknown'
});
const createDateFormatter = (format, tz) => date => {
  const m = _moment.default.tz(date, tz);
  return m.isValid() ? m.format(format) : NA;
};
const ReportInfoFlyoutContent = ({
  info,
  config
}) => {
  var _info$metrics$pdf$cpu, _info$metrics, _info$metrics$pdf, _info$metrics2, _info$metrics2$png, _info$metrics$pdf$mem, _info$metrics3, _info$metrics3$pdf, _info$metrics4, _info$metrics4$png, _info$metrics5, _info$metrics5$csv, _info$metrics6, _info$metrics6$pdf, _info$size, _info$metrics7, _info$metrics7$csv, _info$metrics7$csv$ro, _info$layout, _info$layout$dimensio, _info$layout2, _info$layout2$dimensi, _info$metrics8, _info$metrics8$pdf;
  const {
    services: {
      uiSettings,
      docLinks
    }
  } = (0, _reportingPublic.useKibana)();
  const timezone = uiSettings.get('dateFormat:tz') === 'Browser' ? _moment.default.tz.guess() : uiSettings.get('dateFormat:tz');
  const showKibanaVersion = Boolean(info.version) && config.statefulSettings.enabled;
  const formatDate = createDateFormatter(uiSettings.get('dateFormat'), timezone);
  const formatMilliseconds = millis => _i18n.i18n.translate('xpack.reporting.listing.infoPanel.msToSeconds', {
    defaultMessage: '{seconds} seconds',
    values: {
      seconds: (millis / 1000).toFixed(3)
    }
  });
  const hasStarted = info.started_at != null;
  const hasCompleted = info.completed_at != null;
  const cpuInPercentage = (_info$metrics$pdf$cpu = (_info$metrics = info.metrics) === null || _info$metrics === void 0 ? void 0 : (_info$metrics$pdf = _info$metrics.pdf) === null || _info$metrics$pdf === void 0 ? void 0 : _info$metrics$pdf.cpuInPercentage) !== null && _info$metrics$pdf$cpu !== void 0 ? _info$metrics$pdf$cpu : (_info$metrics2 = info.metrics) === null || _info$metrics2 === void 0 ? void 0 : (_info$metrics2$png = _info$metrics2.png) === null || _info$metrics2$png === void 0 ? void 0 : _info$metrics2$png.cpuInPercentage;
  const memoryInMegabytes = (_info$metrics$pdf$mem = (_info$metrics3 = info.metrics) === null || _info$metrics3 === void 0 ? void 0 : (_info$metrics3$pdf = _info$metrics3.pdf) === null || _info$metrics3$pdf === void 0 ? void 0 : _info$metrics3$pdf.memoryInMegabytes) !== null && _info$metrics$pdf$mem !== void 0 ? _info$metrics$pdf$mem : (_info$metrics4 = info.metrics) === null || _info$metrics4 === void 0 ? void 0 : (_info$metrics4$png = _info$metrics4.png) === null || _info$metrics4$png === void 0 ? void 0 : _info$metrics4$png.memoryInMegabytes;
  const hasCsvRows = ((_info$metrics5 = info.metrics) === null || _info$metrics5 === void 0 ? void 0 : (_info$metrics5$csv = _info$metrics5.csv) === null || _info$metrics5$csv === void 0 ? void 0 : _info$metrics5$csv.rows) != null;
  const hasPagingStrategy = info.pagingStrategy != null;
  const hasScreenshot = _constants.USES_HEADLESS_JOB_TYPES.includes(info.jobtype);
  const hasPdfPagesMetric = ((_info$metrics6 = info.metrics) === null || _info$metrics6 === void 0 ? void 0 : (_info$metrics6$pdf = _info$metrics6.pdf) === null || _info$metrics6$pdf === void 0 ? void 0 : _info$metrics6$pdf.pages) != null;
  const outputInfo = [{
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.statusInfo', {
      defaultMessage: 'Status'
    }),
    description: info.prettyStatus
  }, showKibanaVersion && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.kibanaVersion', {
      defaultMessage: 'Kibana version'
    }),
    description: info.version
  }, Boolean(info.spaceId) && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.space', {
      defaultMessage: 'Kibana space'
    }),
    description: info.spaceId
  }, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.attemptsInfo', {
      defaultMessage: 'Attempts'
    }),
    description: info.max_attempts ? _i18n.i18n.translate('xpack.reporting.listing.infoPanel.attempts', {
      defaultMessage: '{attempts} of {maxAttempts}',
      values: {
        attempts: info.attempts,
        maxAttempts: info.max_attempts
      }
    }) : info.attempts
  }, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.contentTypeInfo', {
      defaultMessage: 'Content type'
    }),
    description: info.content_type || NA
  }, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.sizeInfo', {
      defaultMessage: 'Size in bytes'
    }),
    description: ((_info$size = info.size) === null || _info$size === void 0 ? void 0 : _info$size.toString()) || NA
  }, hasCsvRows && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.csvRows', {
      defaultMessage: 'CSV rows'
    }),
    description: ((_info$metrics7 = info.metrics) === null || _info$metrics7 === void 0 ? void 0 : (_info$metrics7$csv = _info$metrics7.csv) === null || _info$metrics7$csv === void 0 ? void 0 : (_info$metrics7$csv$ro = _info$metrics7$csv.rows) === null || _info$metrics7$csv$ro === void 0 ? void 0 : _info$metrics7$csv$ro.toString()) || NA
  }, hasPagingStrategy && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.csvSearchStrategy', {
      defaultMessage: 'Search strategy'
    }),
    description: info.pagingStrategy || NA
  }, hasScreenshot && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.dimensionsInfoHeight', {
      defaultMessage: 'Height in pixels'
    }),
    description: ((_info$layout = info.layout) === null || _info$layout === void 0 ? void 0 : (_info$layout$dimensio = _info$layout.dimensions) === null || _info$layout$dimensio === void 0 ? void 0 : _info$layout$dimensio.height) != null ? Math.ceil(info.layout.dimensions.height) : UNKNOWN
  }, hasScreenshot && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.dimensionsInfoWidth', {
      defaultMessage: 'Width in pixels'
    }),
    description: ((_info$layout2 = info.layout) === null || _info$layout2 === void 0 ? void 0 : (_info$layout2$dimensi = _info$layout2.dimensions) === null || _info$layout2$dimensi === void 0 ? void 0 : _info$layout2$dimensi.width) != null ? Math.ceil(info.layout.dimensions.width) : UNKNOWN
  }, hasPdfPagesMetric && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.pdfPagesInfo', {
      defaultMessage: 'Pages count'
    }),
    description: (_info$metrics8 = info.metrics) === null || _info$metrics8 === void 0 ? void 0 : (_info$metrics8$pdf = _info$metrics8.pdf) === null || _info$metrics8$pdf === void 0 ? void 0 : _info$metrics8$pdf.pages
  }, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.jobId', {
      defaultMessage: 'Report job ID'
    }),
    description: info.id
  }, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.processedByInfo', {
      defaultMessage: 'Processed by'
    }),
    description: info.kibana_name && info.kibana_id ? `${info.kibana_name} (${info.kibana_id})` : NA
  }, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.timeoutInfo', {
      defaultMessage: 'Timeout'
    }),
    description: info.prettyTimeout
  }, cpuInPercentage != null && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.cpuInfo', {
      defaultMessage: 'CPU usage'
    }),
    description: `${cpuInPercentage}%`
  }, memoryInMegabytes != null && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.memoryInfo', {
      defaultMessage: 'RAM usage'
    }),
    description: `${memoryInMegabytes}MB`
  }].filter(Boolean);
  const timestampsInfo = [{
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.tzInfo', {
      defaultMessage: 'Time zone'
    }),
    description: info.browserTimezone || NA
  }, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.createdAtInfo', {
      defaultMessage: 'Created at'
    }),
    description: info.created_at ? formatDate(info.created_at) : NA
  }, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.startedAtInfo', {
      defaultMessage: 'Started at'
    }),
    description: info.started_at ? formatDate(info.started_at) : NA
  }, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.completedAtInfo', {
      defaultMessage: 'Completed at'
    }),
    description: info.completed_at ? formatDate(info.completed_at) : NA
  }, hasStarted && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.queueTime', {
      defaultMessage: 'Queue time'
    }),
    description: info.queue_time_ms ? formatMilliseconds(info.queue_time_ms) : NA
  }, hasCompleted && {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.executionTime', {
      defaultMessage: 'Execution time'
    }),
    description: info.execution_time_ms ? formatMilliseconds(info.execution_time_ms) : NA
  }].filter(Boolean);
  const warnings = info.getWarnings();
  const errored =
  /*
   * We link the user to documentation if they hit this error case. Note: this
   * should only occur on cloud.
   */
  info.error_code === _errors.VisualReportingSoftDisabledError.code ? _shared_i18n_texts.sharedI18nTexts.cloud.insufficientMemoryError(docLinks.links.reporting.cloudMinimumRequirements) : info.getError();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Boolean(errored) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.callout.failedReportTitle', {
      defaultMessage: 'No report generated'
    }),
    color: "danger",
    css: {
      overflowWrap: 'break-word'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 11
    }
  }, errored), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  })), Boolean(warnings) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Boolean(errored) && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 32
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.reporting.listing.infoPanel.callout.warningsTitle', {
      defaultMessage: 'Report contains warnings'
    }),
    color: "warning",
    css: {
      overflowWrap: 'break-word'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 11
    }
  }, warnings)), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.reporting.listing.infoPanel.outputSectionTitle', {
    defaultMessage: 'Output'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: outputInfo,
    type: "column",
    align: "center",
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.reporting.listing.infoPanel.timestampSectionTitle', {
    defaultMessage: 'Timestamps'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: timestampsInfo,
    type: "column",
    align: "center",
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 7
    }
  }));
};
exports.ReportInfoFlyoutContent = ReportInfoFlyoutContent;