"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStackTracesTabs = getStackTracesTabs;
var _i18n = require("@kbn/i18n");
var _profilingUtils = require("@kbn/profiling-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getStackTracesTabs({
  path,
  query,
  profilingRouter
}) {
  return [{
    label: _i18n.i18n.translate('xpack.profiling.stackTracesView.executablesTabLabel', {
      defaultMessage: 'Executables'
    }),
    topNType: _profilingUtils.TopNType.Executables
  }, {
    label: _i18n.i18n.translate('xpack.profiling.stackTracesView.threadsTabLabel', {
      defaultMessage: 'Threads'
    }),
    topNType: _profilingUtils.TopNType.Threads
  }, {
    label: _i18n.i18n.translate('xpack.profiling.stackTracesView.tracesTabLabel', {
      defaultMessage: 'Traces'
    }),
    topNType: _profilingUtils.TopNType.Traces
  }, {
    label: _i18n.i18n.translate('xpack.profiling.stackTracesView.hostsTabLabel', {
      defaultMessage: 'Hosts'
    }),
    topNType: _profilingUtils.TopNType.Hosts
  }, {
    label: _i18n.i18n.translate('xpack.profiling.stackTracesView.deploymentsTabLabel', {
      defaultMessage: 'Deployments'
    }),
    topNType: _profilingUtils.TopNType.Deployments
  }, {
    label: _i18n.i18n.translate('xpack.profiling.stackTracesView.containersTabLabel', {
      defaultMessage: 'Containers'
    }),
    topNType: _profilingUtils.TopNType.Containers
  }].map(tab => ({
    label: tab.label,
    isSelected: tab.topNType === path.topNType,
    href: profilingRouter.link(`/stacktraces/{topNType}`, {
      path: {
        topNType: tab.topNType
      },
      query
    })
  }));
}