"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _project_list_item = require("./project_list_item");
var _i18n = require("../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/presentation_util/public/components/labs/project_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  List: strings
} = _i18n.LabsStrings.Components;
const EmptyList = ({
  solutions
}) => {
  let title = strings.getNoProjectsMessage();
  if ((solutions === null || solutions === void 0 ? void 0 : solutions.length) === 1) {
    const solution = solutions[0];
    switch (solution) {
      case 'dashboard':
        title = strings.getNoProjectsInSolutionMessage('Dashboard');
      case 'canvas':
        title = strings.getNoProjectsInSolutionMessage('Canvas');
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 10
    }
  });
};
const ProjectList = props => {
  const {
    solutions,
    projects,
    onStatusChange
  } = props;
  const styles = useStyles();
  const items = Object.values(projects).map(project => {
    if (!project.isDisplayed) {
      return null;
    }

    // Filter out any panels that don't match the solutions filter, (if provided).
    if (solutions && !solutions.some(solution => project.solutions.includes(solution))) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("li", {
      key: project.id,
      css: styles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_project_list_item.ProjectListItem, {
      project: project,
      onStatusChange: onStatusChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    }));
  }).filter(item => item !== null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, items.length > 0 ? /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 27
    }
  }, items) : /*#__PURE__*/_react.default.createElement(EmptyList, {
    solutions: solutions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 46
    }
  }));
};
exports.ProjectList = ProjectList;
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _react.useMemo)(() => {
    return (0, _react2.css)({
      position: 'relative',
      padding: `${euiTheme.size.m} ${euiTheme.size.xs}`,
      background: euiTheme.colors.emptyShade,
      minWidth: '500px',
      '&:first-child': {
        paddingTop: 0
      },
      '&:not(:first-child):after': {
        position: 'absolute',
        top: 0,
        right: 0,
        left: 0,
        height: '1px',
        background: euiTheme.colors.lightShade,
        content: '""'
      }
    });
  }, [euiTheme]);
  return styles;
};