"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanelHoverActions = void 0;
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/ui-actions-plugin/public");
var _react2 = require("@emotion/react");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _kibana_services = require("../../kibana_services");
var _panel_actions = require("../../panel_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/presentation_panel/public/panel_component/panel_header/presentation_panel_hover_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getContextMenuAriaLabel = (title, index) => {
  if (title) {
    return _i18n.i18n.translate('presentationPanel.contextMenu.ariaLabelWithTitle', {
      defaultMessage: 'Panel options for {title}',
      values: {
        title
      }
    });
  }
  if (index) {
    return _i18n.i18n.translate('presentationPanel.contextMenu.ariaLabelWithIndex', {
      defaultMessage: 'Options for panel {index}',
      values: {
        index
      }
    });
  }
  return _i18n.i18n.translate('presentationPanel.contextMenu.ariaLabel', {
    defaultMessage: 'Panel options'
  });
};
const QUICK_ACTION_IDS = {
  edit: ['editPanel', 'ACTION_CONFIGURE_IN_LENS', 'ACTION_CUSTOMIZE_PANEL', 'ACTION_OPEN_IN_DISCOVER', 'ACTION_VIEW_SAVED_SEARCH', 'CONVERT_LEGACY_MARKDOWN'],
  view: ['ACTION_SHOW_CONFIG_PANEL', 'ACTION_OPEN_IN_DISCOVER', 'ACTION_VIEW_SAVED_SEARCH', 'openInspector', 'togglePanel']
};
const ALLOWED_NOTIFICATIONS = ['ACTION_FILTERS_NOTIFICATION'];
const createClickHandler = (action, context) => event => {
  if (event.currentTarget instanceof HTMLAnchorElement) {
    // from react-router's <Link/>
    if (!event.defaultPrevented &&
    // onClick prevented default
    event.button === 0 && (
    // ignore everything but left clicks
    !event.currentTarget.target || event.currentTarget.target === '_self') &&
    // let browser handle "target=_blank" etc.
    !(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey) // ignore clicks with modifier keys
    ) {
      event.preventDefault();
    }
  }
  event.currentTarget.blur();
  action.execute(context);
};
const PresentationPanelHoverActions = ({
  api,
  index,
  getActions,
  setDragHandle,
  actionPredicate,
  children,
  className,
  viewMode,
  showNotifications = true
}) => {
  var _api$parentApi;
  const [quickActions, setQuickActions] = (0, _react.useState)([]);
  const [contextMenuPanels, setContextMenuPanels] = (0, _react.useState)([]);
  const [showNotification, setShowNotification] = (0, _react.useState)(false);
  const [isContextMenuOpen, setIsContextMenuOpen] = (0, _react.useState)(false);
  const [notifications, setNotifications] = (0, _react.useState)([]);
  const dragHandleRef = (0, _react.useRef)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [title, description, hidePanelTitle, hasLockedHoverActions, parentHideTitle] = (0, _presentationPublishing.useBatchedOptionalPublishingSubjects)(api === null || api === void 0 ? void 0 : api.title$, api === null || api === void 0 ? void 0 : api.description$, api === null || api === void 0 ? void 0 : api.hideTitle$, api === null || api === void 0 ? void 0 : api.hasLockedHoverActions$, api === null || api === void 0 ? void 0 : (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.hideTitle$);
  const hideTitle = hidePanelTitle || parentHideTitle;
  const showDescription = description && (!title || hideTitle);
  const quickActionIds = (0, _react.useMemo)(() => QUICK_ACTION_IDS[viewMode === 'edit' ? 'edit' : 'view'], [viewMode]);
  const onClose = (0, _react.useCallback)(() => {
    setIsContextMenuOpen(false);
    if ((0, _presentationPublishing.apiCanLockHoverActions)(api)) {
      api === null || api === void 0 ? void 0 : api.lockHoverActions(false);
    }
  }, [api]);
  (0, _react.useEffect)(() => {
    if (!api) return;
    let canceled = false;
    const apiContext = {
      embeddable: api
    };
    const subscriptions = new _rxjs.Subscription();
    const handleActionCompatibilityChange = (type, isCompatible, action) => {
      if (canceled) return;
      (type === 'quickActions' ? setQuickActions : setNotifications)(currentActions => {
        const newActions = currentActions === null || currentActions === void 0 ? void 0 : currentActions.filter(current => current.id !== action.id);
        if (isCompatible) return [...newActions, action];
        return newActions;
      });
    };
    (async () => {
      // subscribe to any frequently changing context menu actions
      const frequentlyChangingActions = await _kibana_services.uiActions.getFrequentlyChangingActionsForTrigger(_panel_actions.CONTEXT_MENU_TRIGGER, apiContext);
      if (canceled) return;
      for (const frequentlyChangingAction of frequentlyChangingActions) {
        if (quickActionIds.includes(frequentlyChangingAction.id)) {
          var _frequentlyChangingAc;
          const compatibilitySubscription = (_frequentlyChangingAc = frequentlyChangingAction.getCompatibilityChangesSubject(apiContext)) === null || _frequentlyChangingAc === void 0 ? void 0 : _frequentlyChangingAc.pipe((0, _rxjs.switchMap)(async () => {
            return await frequentlyChangingAction.isCompatible({
              ...apiContext,
              trigger: _panel_actions.contextMenuTrigger
            });
          })).subscribe(async isCompatible => {
            handleActionCompatibilityChange('quickActions', isCompatible, frequentlyChangingAction);
          });
          subscriptions.add(compatibilitySubscription);
        }
      }

      // subscribe to any frequently changing notification actions
      const frequentlyChangingNotifications = await _kibana_services.uiActions.getFrequentlyChangingActionsForTrigger(_panel_actions.PANEL_NOTIFICATION_TRIGGER, apiContext);
      if (canceled) return;
      for (const frequentlyChangingNotification of frequentlyChangingNotifications) {
        if (ALLOWED_NOTIFICATIONS.includes(frequentlyChangingNotification.id)) {
          var _frequentlyChangingNo;
          const compatibilitySubscription = (_frequentlyChangingNo = frequentlyChangingNotification.getCompatibilityChangesSubject(apiContext)) === null || _frequentlyChangingNo === void 0 ? void 0 : _frequentlyChangingNo.pipe((0, _rxjs.switchMap)(async () => {
            return await frequentlyChangingNotification.isCompatible({
              ...apiContext,
              trigger: _panel_actions.panelNotificationTrigger
            });
          })).subscribe(async isCompatible => {
            handleActionCompatibilityChange('notifications', isCompatible, frequentlyChangingNotification);
          });
          subscriptions.add(compatibilitySubscription);
        }
      }
    })();
    return () => {
      canceled = true;
      subscriptions.unsubscribe();
    };
  }, [api, quickActionIds]);
  (0, _react.useEffect)(() => {
    if (!api) return;
    let canceled = false;
    const apiContext = {
      embeddable: api
    };
    (async _api$disabledActionId => {
      let compatibleActions = await (async _await$uiActions$getT => {
        if (getActions) return await getActions(_panel_actions.CONTEXT_MENU_TRIGGER, apiContext);
        return (_await$uiActions$getT = await _kibana_services.uiActions.getTriggerCompatibleActions(_panel_actions.CONTEXT_MENU_TRIGGER, {
          embeddable: api
        })) !== null && _await$uiActions$getT !== void 0 ? _await$uiActions$getT : [];
      })();
      if (canceled) return;
      const disabledActions = (_api$disabledActionId = api.disabledActionIds$) === null || _api$disabledActionId === void 0 ? void 0 : _api$disabledActionId.value;
      if (disabledActions) {
        compatibleActions = compatibleActions.filter(action => disabledActions.indexOf(action.id) === -1);
      }
      if (actionPredicate) {
        compatibleActions = compatibleActions.filter(({
          id
        }) => actionPredicate(id));
      }
      compatibleActions.sort(({
        order: orderA
      }, {
        order: orderB
      }) => (orderB || 0) - (orderA || 0));
      const contextMenuActions = compatibleActions.filter(({
        id
      }) => !quickActionIds.includes(id));
      const menuPanels = await (0, _public.buildContextMenuForActions)({
        actions: contextMenuActions.map(action => ({
          action,
          context: apiContext,
          trigger: _panel_actions.contextMenuTrigger
        })),
        closeMenu: onClose
      });
      setContextMenuPanels(menuPanels);
      setShowNotification(contextMenuActions.some(action => action.showNotification));
      setQuickActions(compatibleActions.filter(({
        id
      }) => quickActionIds.includes(id)));
    })();
    return () => {
      canceled = true;
    };
  }, [actionPredicate, api, getActions, isContextMenuOpen, onClose, viewMode, quickActionIds]);
  const quickActionElements = (0, _react.useMemo)(() => {
    if (!api || quickActions.length < 1) return [];
    const apiContext = {
      embeddable: api,
      trigger: _panel_actions.contextMenuTrigger
    };
    return quickActions.sort(({
      order: orderA
    }, {
      order: orderB
    }) => {
      const orderComparison = (orderB || 0) - (orderA || 0);
      return orderComparison;
    }).map(action => {
      const name = action.getDisplayName(apiContext);
      const iconType = action.getIconType(apiContext);
      const id = action.id;
      return {
        iconType,
        'data-test-subj': `embeddablePanelAction-${action.id}`,
        onClick: createClickHandler(action, apiContext),
        name,
        id
      };
    });
  }, [api, quickActions]);
  const notificationElements = (0, _react.useMemo)(() => {
    if (!showNotifications || !api) return [];
    return notifications === null || notifications === void 0 ? void 0 : notifications.map(notification => {
      let notificationComponent = notification.MenuItem ? (/*#__PURE__*/_react.default.createElement(notification.MenuItem, {
        key: notification.id,
        context: {
          embeddable: api,
          trigger: _panel_actions.panelNotificationTrigger
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        "data-test-subj": `embeddablePanelNotification-${notification.id}`,
        key: notification.id,
        css: {
          marginTop: euiTheme.size.xs,
          marginRight: euiTheme.size.xs
        },
        onClick: () => notification.execute({
          embeddable: api,
          trigger: _panel_actions.panelNotificationTrigger
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 343,
          columnNumber: 9
        }
      }, notification.getDisplayName({
        embeddable: api,
        trigger: _panel_actions.panelNotificationTrigger
      }));
      if (notification.getDisplayNameTooltip) {
        const tooltip = notification.getDisplayNameTooltip({
          embeddable: api,
          trigger: _panel_actions.panelNotificationTrigger
        });
        if (tooltip) {
          notificationComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            position: "top",
            delay: "regular",
            content: tooltip,
            key: notification.id,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 363,
              columnNumber: 13
            }
          }, notificationComponent);
        }
      }
      return notificationComponent;
    });
  }, [api, euiTheme.size.xs, notifications, showNotifications]);
  const contextMenuClasses = (0, _classnames.default)({
    // eslint-disable-next-line @typescript-eslint/naming-convention
    embPanel__optionsMenuPopover: true,
    'embPanel__optionsMenuPopover-notification': showNotification
  });
  const ContextMenuButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    "data-test-subj": "embeddablePanelToggleMenuIcon",
    "aria-label": getContextMenuAriaLabel(title, index),
    onClick: () => {
      setIsContextMenuOpen(!isContextMenuOpen);
      if ((0, _presentationPublishing.apiCanLockHoverActions)(api)) {
        api.lockHoverActions(!hasLockedHoverActions);
      }
    },
    iconType: "boxesVertical",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 5
    }
  });
  const dragHandle = (0, _react.useMemo)(
  // memoize the drag handle to avoid calling `setDragHandle` unnecessarily
  () => /*#__PURE__*/_react.default.createElement("button", {
    className: `embPanel--dragHandle`,
    css: (0, _react2.css)`
          cursor: move;
          visibility: hidden; // default for every mode **except** edit mode
          width: 0px;

          .embPanel__hoverActionsAnchor--editMode & {
            width: auto;
            visibility: visible; // overwrite visibility in edit mode
          }
        `,
    ref: ref => {
      dragHandleRef.current = ref;
      setDragHandle('hoverActions', ref);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "move",
    color: "text",
    css: (0, _react2.css)`
            margin: ${euiTheme.size.xs};
          `,
    "data-test-subj": "embeddablePanelDragHandle",
    "aria-label": _i18n.i18n.translate('presentationPanel.dragHandle', {
      defaultMessage: 'Move panel'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 9
    }
  })), [setDragHandle, euiTheme.size.xs]);
  const hasHoverActions = quickActionElements.length || contextMenuPanels.lastIndexOf.length;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, api && hasHoverActions && /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('embPanel__hoverActions', className),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 9
    }
  }, dragHandle, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 11
    }
  }, showNotifications && notificationElements, showDescription && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "m",
    title: !hideTitle ? title || undefined : undefined,
    content: description,
    delay: "regular",
    position: "top",
    "data-test-subj": "embeddablePanelDescriptionTooltip",
    type: "info",
    iconProps: {
      css: (0, _react2.css)`
                    margin: ${euiTheme.size.xs};
                  `
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 15
    }
  }), quickActionElements.map(({
    iconType,
    'data-test-subj': dataTestSubj,
    onClick,
    name
  }, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    key: `main_action_${dataTestSubj}_${api === null || api === void 0 ? void 0 : api.uuid}`,
    content: name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 460,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: iconType,
    color: "text",
    onClick: onClick,
    "data-test-subj": dataTestSubj,
    "aria-label": name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 19
    }
  }))), contextMenuPanels.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    repositionOnScroll: true,
    panelPaddingSize: "none",
    anchorPosition: "downRight",
    button: ContextMenuButton,
    isOpen: isContextMenuOpen,
    className: contextMenuClasses,
    closePopover: onClose,
    "data-test-subj": isContextMenuOpen ? 'embeddablePanelContextMenuOpen' : 'embeddablePanelContextMenuClosed',
    focusTrapProps: {
      closeOnMouseup: true,
      clickOutsideDisables: false,
      onClickOutside: onClose
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 472,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    "data-test-subj": "presentationPanelContextMenuItems",
    initialPanelId: 'mainMenu',
    panels: contextMenuPanels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 491,
      columnNumber: 17
    }
  })) : null)));
};
exports.PresentationPanelHoverActions = PresentationPanelHoverActions;