"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _lodash = require("lodash");
var _use_pack = require("../../packs/use_pack");
var _query_pack_selectable = require("../../live_queries/form/query_pack_selectable");
var _kibana = require("../../common/lib/kibana");
var _live_query_query_field = _interopRequireDefault(require("../../live_queries/form/live_query_query_field"));
var _pack_field_wrapper = require("./pack_field_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/shared_components/osquery_response_action_type/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OsqueryResponseActionParamsFormComponent = ({
  defaultValues,
  onError,
  onChange
}) => {
  const hooksForm = (0, _reactHookForm.useForm)({
    mode: 'all',
    defaultValues: defaultValues ? {
      ...(0, _lodash.omit)(defaultValues, ['ecsMapping', 'packId']),
      ecs_mapping: defaultValues.ecsMapping,
      packId: defaultValues.packId ? [defaultValues.packId] : [],
      queryType: defaultValues.packId ? 'pack' : 'query'
    } : {
      ecs_mapping: {},
      queryType: 'query'
    }
  });
  const {
    watch,
    register,
    formState,
    control
  } = hooksForm;
  const [packId, queryType, queries] = watch(['packId', 'queryType', 'queries']);
  const {
    data: packData
  } = (0, _use_pack.usePack)({
    packId: packId === null || packId === void 0 ? void 0 : packId[0],
    skip: !(packId !== null && packId !== void 0 && packId[0])
  });
  const {
    replace
  } = (0, _reactHookForm.useFieldArray)({
    name: 'queries',
    control
  });
  (0, _react.useEffect)(() => {
    if (packData !== null && packData !== void 0 && packData.queries) {
      const queriesArray = (0, _lodash.map)(packData === null || packData === void 0 ? void 0 : packData.queries, (query, queryId) => ({
        ...query,
        id: queryId
      }));
      replace(queriesArray);
    }
  }, [packData, replace]);
  (0, _react.useEffect)(() => {
    onError(formState.errors);
  }, [onError, formState]);
  (0, _react.useEffect)(() => {
    register('savedQueryId');
  }, [register]);
  (0, _react.useEffect)(() => {
    const subscription = watch(formData => {
      var _formData$packId;
      onChange(
      // @ts-expect-error update types
      formData.queryType === 'pack' ? {
        packId: formData !== null && formData !== void 0 && (_formData$packId = formData.packId) !== null && _formData$packId !== void 0 && _formData$packId.length ? formData === null || formData === void 0 ? void 0 : formData.packId[0] : undefined,
        queries: formData.queries
      } : {
        savedQueryId: formData.savedQueryId,
        query: formData.query,
        timeout: formData.timeout,
        ecsMapping: formData.ecs_mapping
      });
    });
    return () => subscription.unsubscribe();
  }, [onChange, packData, watch]);
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const canRunPacks = (0, _react.useMemo)(() => !!((permissions.runSavedQueries || permissions.writeLiveQueries) && permissions.readPacks), [permissions]);
  const canRunSingleQuery = (0, _react.useMemo)(() => !!(permissions.writeLiveQueries || permissions.runSavedQueries && permissions.readSavedQueries), [permissions]);
  const queryDetails = (0, _react.useMemo)(() => ({
    queries,
    agents: []
  }), [queries]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, hooksForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_query_pack_selectable.QueryPackSelectable, {
    canRunPacks: canRunPacks,
    canRunSingleQuery: canRunSingleQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }), queryType === 'query' && /*#__PURE__*/_react.default.createElement(_live_query_query_field.default, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 35
    }
  }), queryType === 'pack' && /*#__PURE__*/_react.default.createElement(_pack_field_wrapper.PackFieldWrapper, {
    liveQueryDetails: queries && !packData ? queryDetails : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  })));
};
const OsqueryResponseActionParamsForm = exports.default = /*#__PURE__*/_react.default.memo(OsqueryResponseActionParamsFormComponent);

// Export as default in order to support lazy loading
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;