"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedQueriesDropdown = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _constants = require("./constants");
var _osquery_schema_link = require("../components/osquery_schema_link");
var _use_saved_queries = require("./use_saved_queries");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/saved_queries/saved_queries_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const euiCodeBlockCss = {
  '.euiCodeBlock__line': {
    whiteSpace: 'nowrap'
  }
};
const SavedQueriesDropdownComponent = ({
  disabled,
  onChange
}) => {
  var _errors$query;
  const savedQueryId = (0, _reactHookForm.useWatch)({
    name: 'savedQueryId'
  });
  const context = (0, _reactHookForm.useFormContext)();
  const {
    errors
  } = context.formState;
  const queryFieldError = errors === null || errors === void 0 ? void 0 : (_errors$query = errors.query) === null || _errors$query === void 0 ? void 0 : _errors$query.message;
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const {
    data
  } = (0, _use_saved_queries.useSavedQueries)({});
  const queryOptions = (0, _react.useMemo)(() => {
    var _data$data$map, _data$data;
    return (_data$data$map = data === null || data === void 0 ? void 0 : (_data$data = data.data) === null || _data$data === void 0 ? void 0 : _data$data.map(savedQuery => {
      var _savedQuery$id;
      return {
        label: (_savedQuery$id = savedQuery.id) !== null && _savedQuery$id !== void 0 ? _savedQuery$id : '',
        value: {
          savedQueryId: savedQuery.id,
          id: savedQuery.id,
          description: savedQuery.description,
          query: savedQuery.query,
          ecs_mapping: savedQuery.ecs_mapping
        }
      };
    })) !== null && _data$data$map !== void 0 ? _data$data$map : [];
  }, [data]);
  const handleSavedQueryChange = (0, _react.useCallback)(newSelectedOptions => {
    if (!newSelectedOptions.length) {
      onChange(null);
      setSelectedOptions(newSelectedOptions);
      return;
    }
    const selectedSavedQuery = (0, _fp.find)(['id', newSelectedOptions[0].value.id], data === null || data === void 0 ? void 0 : data.data);
    if (selectedSavedQuery) {
      onChange({
        ...selectedSavedQuery,
        savedQueryId: selectedSavedQuery.id
      });
    }
    setSelectedOptions(newSelectedOptions);
  }, [data, onChange]);
  const renderOption = (0, _react.useCallback)(({
    value
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, value.id), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, value.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    css: euiCodeBlockCss,
    language: "sql",
    fontSize: "m",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, value.query.split('\n').join(' '))), []);
  (0, _react.useEffect)(() => {
    if (savedQueryId) {
      const savedQueryOption = (0, _fp.find)(['value.savedQueryId', savedQueryId], queryOptions);
      if (savedQueryOption) {
        setSelectedOptions([savedQueryOption]);
      }
    }
  }, [savedQueryId, queryOptions]);
  (0, _react.useEffect)(() => {
    if (selectedOptions.length && selectedOptions[0].value.savedQueryId !== savedQueryId) {
      setSelectedOptions([]);
    }
  }, [savedQueryId, selectedOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !!queryFieldError,
    error: queryFieldError,
    label: _constants.QUERIES_DROPDOWN_SEARCH_FIELD_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_osquery_schema_link.OsquerySchemaLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 20
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: !!queryFieldError,
    "data-test-subj": 'savedQuerySelect',
    isDisabled: disabled,
    fullWidth: true,
    placeholder: _constants.QUERIES_DROPDOWN_LABEL
    // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
    ,
    singleSelection: {
      asPlainText: true
    },
    options: queryOptions,
    selectedOptions: selectedOptions,
    onChange: handleSavedQueryChange,
    renderOption: renderOption,
    rowHeight: 110,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }));
};
SavedQueriesDropdownComponent.displayName = 'SavedQueriesDropdown';
const SavedQueriesDropdown = exports.SavedQueriesDropdown = /*#__PURE__*/_react.default.memo(SavedQueriesDropdownComponent);