"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Packs = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _list = require("./list");
var _add = require("./add");
var _edit = require("./edit");
var _details = require("./details");
var _use_breadcrumbs = require("../../common/hooks/use_breadcrumbs");
var _kibana = require("../../common/lib/kibana");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/routes/packs/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PacksComponent = () => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  (0, _use_breadcrumbs.useBreadcrumbs)('packs');
  const match = (0, _reactRouterDom.useRouteMatch)();
  if (!permissions.readPacks) {
    return /*#__PURE__*/_react.default.createElement(_components.MissingPrivileges, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}/add`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, permissions.writePacks ? /*#__PURE__*/_react.default.createElement(_add.AddPackPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 35
    }
  }) : /*#__PURE__*/_react.default.createElement(_components.MissingPrivileges, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 53
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}/:packId/edit`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, permissions.writePacks ? /*#__PURE__*/_react.default.createElement(_edit.EditPackPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 35
    }
  }) : /*#__PURE__*/_react.default.createElement(_components.MissingPrivileges, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 54
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}/:packId`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_details.PackDetailsPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_list.PacksPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  })));
};
const Packs = exports.Packs = /*#__PURE__*/_react.default.memo(PacksComponent);