"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
var _timeout_field = require("../../form/timeout_field");
var _editor = require("../../editor");
var _kibana = require("../../common/lib/kibana");
var _lazy_ecs_mapping_editor_field = require("../../packs/queries/lazy_ecs_mapping_editor_field");
var _saved_queries_dropdown = require("../../saved_queries/saved_queries_dropdown");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/live_queries/form/live_query_query_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const euiCodeBlockCss = {
  minHeight: '100px'
};
const euiAccordionCss = ({
  euiTheme
}) => ({
  '.euiAccordion__button': {
    color: euiTheme.colors.primary
  },
  '.euiAccordion__childWrapper': {
    '-webkit-transition': 'none'
  }
});
const LiveQueryQueryFieldComponent = ({
  disabled,
  handleSubmitForm
}) => {
  const {
    formState,
    watch,
    resetField
  } = (0, _reactHookForm.useFormContext)();
  const [advancedContentState, setAdvancedContentState] = (0, _react.useState)(() => {
    var _formState$defaultVal;
    return (0, _lodash.isEmpty)((_formState$defaultVal = formState.defaultValues) === null || _formState$defaultVal === void 0 ? void 0 : _formState$defaultVal.ecs_mapping) ? 'closed' : 'open';
  });
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const [queryType] = watch(['queryType']);
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    name: 'query',
    rules: {
      required: {
        message: _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.emptyQueryError', {
          defaultMessage: 'Query is a required field'
        }),
        value: queryType !== 'pack'
      }
    },
    defaultValue: ''
  });
  const handleSavedQueryChange = (0, _react.useCallback)(savedQuery => {
    if (savedQuery) {
      var _savedQuery$ecs_mappi, _savedQuery$timeout;
      resetField('query', {
        defaultValue: savedQuery.query
      });
      resetField('savedQueryId', {
        defaultValue: savedQuery.savedQueryId
      });
      resetField('ecs_mapping', {
        defaultValue: (_savedQuery$ecs_mappi = savedQuery.ecs_mapping) !== null && _savedQuery$ecs_mappi !== void 0 ? _savedQuery$ecs_mappi : {}
      });
      resetField('timeout', {
        defaultValue: (_savedQuery$timeout = savedQuery.timeout) !== null && _savedQuery$timeout !== void 0 ? _savedQuery$timeout : _constants.QUERY_TIMEOUT.DEFAULT
      });
      if (!(0, _lodash.isEmpty)(savedQuery.ecs_mapping)) {
        setAdvancedContentState('open');
      }
    } else {
      resetField('savedQueryId');
    }
  }, [resetField]);
  const handleToggle = (0, _react.useCallback)(isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    setAdvancedContentState(newState);
  }, []);
  const ecsFieldProps = (0, _react.useMemo)(() => ({
    isDisabled: !permissions.writeLiveQueries
  }), [permissions.writeLiveQueries]);
  const isAdvancedToggleHidden = (0, _react.useMemo)(() => !(permissions.writeLiveQueries || permissions.runSavedQueries && permissions.readSavedQueries), [permissions.readSavedQueries, permissions.runSavedQueries, permissions.writeLiveQueries]);
  const isSavedQueryDisabled = (0, _react.useMemo)(() => !permissions.runSavedQueries || !permissions.readSavedQueries, [permissions.readSavedQueries, permissions.runSavedQueries]);
  const commands = (0, _react.useMemo)(() => handleSubmitForm ? [{
    name: 'submitOnCmdEnter',
    exec: handleSubmitForm
  }] : [], [handleSubmitForm]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isSavedQueryDisabled && /*#__PURE__*/_react.default.createElement(_saved_queries_dropdown.SavedQueriesDropdown, {
    disabled: isSavedQueryDisabled,
    onChange: handleSavedQueryChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !!(error !== null && error !== void 0 && error.message),
    error: error === null || error === void 0 ? void 0 : error.message,
    fullWidth: true,
    isDisabled: !permissions.writeLiveQueries || disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, !permissions.writeLiveQueries || disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    css: euiCodeBlockCss,
    language: "sql",
    fontSize: "m",
    paddingSize: "m",
    transparentBackground: !value.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, value) : /*#__PURE__*/_react.default.createElement(_editor.OsqueryEditor, {
    defaultValue: value,
    onChange: onChange,
    commands: commands,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }), !isAdvancedToggleHidden && /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    css: euiAccordionCss,
    id: "advanced",
    forceState: advancedContentState,
    onToggle: handleToggle,
    buttonContent: "Advanced",
    "data-test-subj": "advanced-accordion-content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_timeout_field.TimeoutField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_lazy_ecs_mapping_editor_field.ECSMappingEditorField, {
    euiFieldProps: ecsFieldProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })));
};
const LiveQueryQueryField = exports.default = /*#__PURE__*/_react.default.memo(LiveQueryQueryFieldComponent);

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;