"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processAggregations = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processAggregations = aggs => {
  var _policyTerms$buckets$;
  if (!aggs) {
    return {
      platforms: [],
      overlap: {},
      policies: []
    };
  }
  const platforms = [];
  const overlap = {};
  const platformTerms = aggs.platforms;
  const policyTerms = aggs.policies;
  const policies = (_policyTerms$buckets$ = policyTerms === null || policyTerms === void 0 ? void 0 : policyTerms.buckets.map(o => ({
    name: o.key,
    id: o.key,
    size: o.doc_count
  }))) !== null && _policyTerms$buckets$ !== void 0 ? _policyTerms$buckets$ : [];
  if (platformTerms !== null && platformTerms !== void 0 && platformTerms.buckets) {
    for (const {
      key,
      doc_count: size,
      policies: platformPolicies
    } of platformTerms.buckets) {
      platforms.push({
        name: key,
        id: key,
        size
      });
      if (platformPolicies !== null && platformPolicies !== void 0 && platformPolicies.buckets && policies.length > 0) {
        overlap[key] = platformPolicies.buckets.reduce((acc, pol) => {
          acc[pol.key] = pol.doc_count;
          return acc;
        }, {});
      }
    }
  }
  return {
    platforms,
    overlap,
    policies
  };
};
exports.processAggregations = processAggregations;