"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFallbackKibanaUrl = getFallbackKibanaUrl;
exports.getKibanaUrl = getKibanaUrl;
var _common = require("@kbn/spaces-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getKibanaUrl(coreSetup, cloudSetup, request, spaces) {
  var _ref, _coreSetup$http$baseP;
  const baseUrl = (_ref = (_coreSetup$http$baseP = coreSetup.http.basePath.publicBaseUrl) !== null && _coreSetup$http$baseP !== void 0 ? _coreSetup$http$baseP : cloudSetup === null || cloudSetup === void 0 ? void 0 : cloudSetup.kibanaUrl) !== null && _ref !== void 0 ? _ref : getFallbackKibanaUrl(coreSetup);
  const pathname = new URL(baseUrl).pathname;
  const serverBasePath = coreSetup.http.basePath.serverBasePath;
  const {
    pathHasExplicitSpaceIdentifier
  } = (0, _common.getSpaceIdFromPath)(pathname, serverBasePath);
  if (!pathHasExplicitSpaceIdentifier && request && spaces) {
    var _spaces$spacesService;
    const spaceId = ((_spaces$spacesService = spaces.spacesService) === null || _spaces$spacesService === void 0 ? void 0 : _spaces$spacesService.getSpaceId(request)) || _common.DEFAULT_SPACE_ID;
    return (0, _common.addSpaceIdToPath)(baseUrl, spaceId);
  }
  return baseUrl;
}
function getFallbackKibanaUrl({
  http
}) {
  const basePath = http.basePath;
  const {
    protocol,
    hostname,
    port
  } = http.getServerInfo();
  return `${protocol}://${hostname}:${port}${basePath
  // Prepending on '' removes the serverBasePath
  .prepend('/').slice(0, -1)}`;
}