"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createToolResultStoreMock = exports.createScopedRunnerDepsMock = void 0;
var _loggingMocks = require("@kbn/logging-mocks");
var _mocks = require("@kbn/core/server/mocks");
var _model_provider = require("./model_provider");
var _tools = require("./tools");
var _agents = require("./agents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createToolResultStoreMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    add: jest.fn(),
    delete: jest.fn(),
    asReadonly: jest.fn()
  };
};
exports.createToolResultStoreMock = createToolResultStoreMock;
const createScopedRunnerDepsMock = () => {
  return {
    elasticsearch: _mocks.elasticsearchServiceMock.createStart(),
    security: _mocks.securityServiceMock.createStart(),
    modelProviderFactory: (0, _model_provider.createModelProviderFactoryMock)(),
    toolsService: (0, _tools.createToolsServiceStartMock)(),
    agentsService: (0, _agents.createAgentsServiceStartMock)(),
    logger: _loggingMocks.loggerMock.create(),
    request: _mocks.httpServerMock.createKibanaRequest(),
    resultStore: createToolResultStoreMock()
  };
};
exports.createScopedRunnerDepsMock = createScopedRunnerDepsMock;