"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateSchema = ({
  workflow
}) => {
  if (!workflow.definition || !workflow.definition.inputs) {
    return _zod.z.object({});
  }
  const inputs = workflow.definition.inputs;
  const schemaFields = {};
  for (const input of inputs) {
    schemaFields[input.name] = generateField(input);
  }
  return _zod.z.object(schemaFields).describe('Parameters needed to execute the workflow');
};
exports.generateSchema = generateSchema;
const generateField = input => {
  var _input$description;
  let field;
  switch (input.type) {
    case 'string':
      field = _zod.z.string();
      break;
    case 'number':
      field = _zod.z.number();
      break;
    case 'boolean':
      field = _zod.z.boolean();
      break;
    case 'choice':
      field = _zod.z.enum(input.options);
      break;
    default:
      field = _zod.z.any();
      break;
  }
  field = field.describe((_input$description = input.description) !== null && _input$description !== void 0 ? _input$description : input.name);
  if (input.required !== true) {
    field = field.optional();
  }
  if (input.default) {
    field = field.default(input.default);
  }
  return field;
};