"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationSidebarToggle = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_sidebar/conversation_sidebar_toggle.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const sidebarToggleBtnStyles = (0, _react.css)`
  margin-inline-end: 8px;
  align-self: center;
`;
const ConversationSidebarToggle = ({
  isSidebarOpen,
  onToggle
}) => {
  const labels = {
    open: _i18n.i18n.translate('xpack.onechat.conversationSidebarToggle.open', {
      defaultMessage: 'Open sidebar'
    }),
    close: _i18n.i18n.translate('xpack.onechat.conversationSidebarToggle.close', {
      defaultMessage: 'Close sidebar'
    })
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPageHeaderSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    iconType: isSidebarOpen ? 'transitionLeftOut' : 'transitionLeftIn',
    color: "text",
    "aria-label": isSidebarOpen ? labels.close : labels.open,
    onClick: onToggle,
    css: sidebarToggleBtnStyles,
    display: "empty",
    "data-test-subj": "onechatSidebarToggleBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }));
};
exports.ConversationSidebarToggle = ConversationSidebarToggle;