"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSurveyFeedbackURL = exports.FeatureFeedbackButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_shared/public/components/feature_feedback_button/feature_feedback_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const KIBANA_VERSION_QUERY_PARAM = 'version';
const KIBANA_DEPLOYMENT_TYPE_PARAM = 'deployment_type';
const SANITIZED_PATH_PARAM = 'path';
const ML_JOB_TYPE = 'ml_job_type';
const FEEDBACK_BUTTON_DEFAULT_TEXT = _i18n.i18n.translate('xpack.observabilityShared.featureFeedbackButton.defaultText', {
  defaultMessage: 'Give feedback'
});
const getDeploymentType = (isCloudEnv, isServerlessEnv) => {
  if (isServerlessEnv) {
    return 'Serverless';
  }
  if (isCloudEnv) {
    return 'Elastic Cloud';
  }
  return 'Self-Managed';
};
const getMLJobType = mlJobType => mlJobType === 'pod' ? 'Pod Anomalies' : 'Host Anomalies';
const getSurveyFeedbackURL = ({
  formUrl,
  kibanaVersion,
  sanitizedPath,
  isCloudEnv,
  isServerlessEnv,
  nodeType
}) => {
  const deploymentType = isCloudEnv !== undefined || isServerlessEnv !== undefined ? getDeploymentType(isCloudEnv, isServerlessEnv) : undefined;
  const mlJobType = nodeType ? getMLJobType(nodeType) : undefined;
  const url = new URL(formUrl);
  if (kibanaVersion) {
    url.searchParams.append(KIBANA_VERSION_QUERY_PARAM, kibanaVersion);
  }
  if (deploymentType) {
    url.searchParams.append(KIBANA_DEPLOYMENT_TYPE_PARAM, deploymentType);
  }
  if (sanitizedPath) {
    url.searchParams.append(SANITIZED_PATH_PARAM, sanitizedPath);
  }
  if (mlJobType) {
    url.searchParams.append(ML_JOB_TYPE, mlJobType);
  }
  return url.href;
};
exports.getSurveyFeedbackURL = getSurveyFeedbackURL;
const FeatureFeedbackButton = ({
  formUrl,
  'data-test-subj': dts,
  onClickCapture,
  defaultButton,
  kibanaVersion,
  isCloudEnv,
  isServerlessEnv,
  sanitizedPath,
  nodeType,
  surveyButtonText = FEEDBACK_BUTTON_DEFAULT_TEXT
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": surveyButtonText !== null && surveyButtonText !== void 0 ? surveyButtonText : FEEDBACK_BUTTON_DEFAULT_TEXT,
    href: getSurveyFeedbackURL({
      formUrl,
      kibanaVersion,
      isCloudEnv,
      nodeType,
      isServerlessEnv,
      sanitizedPath
    }),
    size: "s",
    iconType: defaultButton ? undefined : 'popout',
    iconSide: "right",
    target: "_blank",
    onClickCapture: onClickCapture,
    "data-test-subj": dts,
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, surveyButtonText);
};
exports.FeatureFeedbackButton = FeatureFeedbackButton;