"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsTabs = RuleDetailsTabs;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _alerts_table = require("../../../components/alerts_table/alerts_table");
var _common = require("../../../../common");
var _kibana_react = require("../../../utils/kibana_react");
var _alert_search_bar_with_url_sync = require("../../../components/alert_search_bar/alert_search_bar_with_url_sync");
var _constants = require("../constants");
var _get_columns = require("../../../components/alerts_table/common/get_columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/rule_details/components/rule_details_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tableColumns = (0, _get_columns.getColumns)();
function RuleDetailsTabs({
  activeTabId,
  esQuery,
  ruleTypeIds,
  rule,
  ruleId,
  ruleType,
  onSetTabId,
  onEsQueryChange,
  onControlApiAvailable,
  controlApi
}) {
  const {
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    cases,
    settings,
    triggersActionsUi: {
      getRuleEventLogList: RuleEventLogList
    }
  } = (0, _kibana_react.useKibana)().services;
  const [filterControls, setFilterControls] = (0, _react.useState)();
  const hasInitialControlLoadingFinished = (0, _react.useMemo)(() => controlApi && Array.isArray(filterControls), [controlApi, filterControls]);
  const ruleFilters = (0, _react.useRef)([{
    query: {
      match_phrase: {
        'kibana.alert.rule.uuid': ruleId
      }
    },
    meta: {}
  }]);
  const tabs = [{
    id: _constants.RULE_DETAILS_ALERTS_TAB,
    name: _i18n.i18n.translate('xpack.observability.ruleDetails.rule.alertsTabText', {
      defaultMessage: 'Alerts'
    }),
    'data-test-subj': 'ruleAlertListTab',
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_search_bar_with_url_sync.ObservabilityAlertSearchbarWithUrlSync, {
      appName: _constants.RULE_DETAILS_ALERTS_SEARCH_BAR_ID,
      onEsQueryChange: onEsQueryChange,
      urlStorageKey: _constants.RULE_DETAILS_SEARCH_BAR_URL_STORAGE_KEY,
      defaultFilters: ruleFilters.current,
      disableLocalStorageSync: true,
      filterControls: filterControls,
      onFilterControlsChange: setFilterControls,
      onControlApiAvailable: onControlApiAvailable,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      css: {
        minHeight: 450
      },
      direction: 'column',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 13
      }
    }, esQuery && ruleTypeIds && hasInitialControlLoadingFinished && /*#__PURE__*/_react.default.createElement(_alerts_table.ObservabilityAlertsTable, {
      id: _constants.RULE_DETAILS_PAGE_ID,
      ruleTypeIds: ruleTypeIds,
      consumers: _common.observabilityAlertFeatureIds,
      query: esQuery,
      columns: tableColumns,
      services: {
        data,
        http,
        notifications,
        fieldFormats,
        application,
        licensing,
        cases,
        settings
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 17
      }
    }))))
  }, {
    id: _constants.RULE_DETAILS_EXECUTION_TAB,
    name: _i18n.i18n.translate('xpack.observability.ruleDetails.rule.eventLogTabText', {
      defaultMessage: 'Execution history'
    }),
    'data-test-subj': 'eventLogListTab',
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      css: {
        minHeight: 600
      },
      direction: 'column',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 11
      }
    }, rule && ruleType ? /*#__PURE__*/_react.default.createElement(RuleEventLogList, {
      ruleId: rule.id,
      ruleType: ruleType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 33
      }
    }) : null))
  }];
  const handleTabIdChange = newTabId => {
    onSetTabId(newTabId);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "ruleDetailsTabbedContent",
    tabs: tabs,
    selectedTab: tabs.find(tab => tab.id === activeTabId),
    onTabClick: tab => {
      handleTabIdChange(tab.id);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 5
    }
  });
}