"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleFlyoutKueryBar = RuleFlyoutKueryBar;
exports.default = void 0;
var _esQuery = require("@kbn/es-query");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _with_kuery_autocompletion = require("./with_kuery_autocompletion");
var _autocomplete_field = require("./autocomplete_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/rule_kql_filter/kuery_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function validateQuery(query) {
  try {
    (0, _esQuery.fromKueryExpression)(query);
  } catch (err) {
    return false;
  }
  return true;
}
function RuleFlyoutKueryBar({
  derivedIndexPattern,
  onSubmit,
  onChange,
  value,
  placeholder,
  curryLoadSuggestions = defaultCurryLoadSuggestions,
  compressed
}) {
  const [draftQuery, setDraftQuery] = (0, _react.useState)(value || '');
  const [isValid, setValidation] = (0, _react.useState)(true);

  // This ensures that if value changes out side this component it will update.
  (0, _react.useEffect)(() => {
    if (value) {
      setDraftQuery(value);
    }
  }, [value]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleChange = query => {
    setValidation(validateQuery(query));
    setDraftQuery(query);
    if (onChange) {
      onChange(query);
    }
  };
  const filteredDerivedIndexPattern = {
    ...derivedIndexPattern,
    fields: derivedIndexPattern.fields
  };
  return /*#__PURE__*/_react.default.createElement(_with_kuery_autocompletion.WithKueryAutocompletion, {
    indexPattern: filteredDerivedIndexPattern,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, ({
    isLoadingSuggestions,
    loadSuggestions,
    suggestions
  }) => /*#__PURE__*/_react.default.createElement(_autocomplete_field.AutocompleteField, {
    compressed: compressed,
    "aria-label": placeholder,
    isLoadingSuggestions: isLoadingSuggestions,
    isValid: isValid,
    loadSuggestions: curryLoadSuggestions(loadSuggestions),
    onChange: handleChange,
    onSubmit: onSubmit,
    placeholder: placeholder,
    suggestions: suggestions,
    value: draftQuery,
    theme: euiTheme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }));
}
const defaultCurryLoadSuggestions = loadSuggestions => (...args) => loadSuggestions(...args);

// eslint-disable-next-line import/no-default-export
var _default = exports.default = RuleFlyoutKueryBar;