"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BetaBadge = BetaBadge;
exports.ExperimentalBadge = ExperimentalBadge;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/experimental_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ExperimentalBadge() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.observability.experimentalBadgeLabel', {
      defaultMessage: 'Technical preview'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.observability.experimentalBadgeDescription', {
      defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 5
    }
  });
}
function BetaBadge(badgeProps) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, (0, _extends2.default)({
    label: _i18n.i18n.translate('xpack.observability.betaBadgeLabel', {
      defaultMessage: 'Beta'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.observability.betaBadgeDescription', {
      defaultMessage: 'This functionality is in beta and is subject to change.'
    })
  }, badgeProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }));
}