"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveObservabilityOnboardingFlow = saveObservabilityOnboardingFlow;
var _observability_onboarding_status = require("../../saved_objects/observability_onboarding_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function saveObservabilityOnboardingFlow({
  savedObjectsClient,
  observabilityOnboardingState,
  savedObjectId
}) {
  let savedObject;
  if (savedObjectId) {
    savedObject = await savedObjectsClient.update(_observability_onboarding_status.OBSERVABILITY_ONBOARDING_STATE_SAVED_OBJECT_TYPE, savedObjectId, {
      type: observabilityOnboardingState.type,
      state: observabilityOnboardingState.state,
      progress: {
        ...observabilityOnboardingState.progress
      }
    });
  } else {
    savedObject = await savedObjectsClient.create(_observability_onboarding_status.OBSERVABILITY_ONBOARDING_STATE_SAVED_OBJECT_TYPE, observabilityOnboardingState);
  }
  const {
    id,
    updated_at: updatedAt
  } = savedObject;
  return {
    id,
    ...observabilityOnboardingState,
    updatedAt: updatedAt ? Date.parse(updatedAt) : 0
  };
}