"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _telemetry_events = require("../../../../common/telemetry_events");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/shared/empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EmptyPrompt = ({
  onboardingFlowType,
  error,
  telemetryEventContext,
  onRetryClick
}) => {
  var _error$response;
  const {
    services: {
      analytics
    }
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    var _error$body$message, _error$body;
    analytics === null || analytics === void 0 ? void 0 : analytics.reportEvent(_telemetry_events.OBSERVABILITY_ONBOARDING_FLOW_ERROR_TELEMETRY_EVENT.eventType, {
      onboardingFlowType,
      error: (_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message,
      context: telemetryEventContext
    });
  }, [analytics, error, onboardingFlowType, telemetryEventContext]);
  if (((_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status) === 403) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "plain",
      iconType: "lock",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.h2.contactYourAdministratorForLabel', {
        defaultMessage: 'Contact your administrator for access'
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.p.toInstallIntegrationsAndLabel', {
        defaultMessage: 'To install integrations and ingest data, you need additional privileges.'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "danger",
    iconType: "error",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.h2.unableToInitiateDataLabel', {
      defaultMessage: 'Unable to load content'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.p.thereWasAProblemLabel', {
      defaultMessage: 'There was a problem loading the application. Retry or contact your administrator for help.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      iconType: "refresh",
      fill: true,
      "data-test-subj": "observabilityOnboardingAutoDetectPanelGoBackButton",
      onClick: onRetryClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.backToSelectionButtonLabel', {
      defaultMessage: 'Retry'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  });
};
exports.EmptyPrompt = EmptyPrompt;