"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibana = useKibana;
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObservabilityAIAssistantMultipaneFlyoutContext = /*#__PURE__*/_react.default.createContext(undefined);
function useChat() {
  return {
    next: () => {},
    messages: [],
    setMessages: () => {},
    state: undefined,
    stop: () => {}
  };
}
function useKibana() {
  return {
    services: {
      application: {
        navigateToApp: () => {}
      },
      http: {
        basePath: {
          prepend: () => ''
        }
      },
      notifications: {
        toasts: {
          addSuccess: () => {},
          addError: () => {}
        }
      },
      plugins: {
        start: {
          licensing: {
            license$: new _rxjs.Subject()
          },
          observabilityAIAssistant: {
            useChat,
            ObservabilityAIAssistantMultipaneFlyoutContext
          },
          share: {
            url: {
              locators: {
                get: () => {}
              }
            }
          },
          triggersActionsUi: {
            getAddConnectorFlyout: {}
          }
        }
      },
      uiSettings: {
        get: setting => {
          if (setting === 'dateFormat') {
            return 'MMM D, YYYY HH:mm';
          }
        }
      }
    }
  };
}